/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest;

public class DeleteIdentityPolicyRequestMarshaller
implements Marshaller<Request<DeleteIdentityPolicyRequest>, DeleteIdentityPolicyRequest> {
    public Request<DeleteIdentityPolicyRequest> marshall(DeleteIdentityPolicyRequest deleteIdentityPolicyRequest) {
        if (deleteIdentityPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteIdentityPolicyRequest, "SesClient");
        request.addParameter("Action", "DeleteIdentityPolicy");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteIdentityPolicyRequest.identity() != null) {
            request.addParameter("Identity", StringConversion.fromString((String)deleteIdentityPolicyRequest.identity()));
        }
        if (deleteIdentityPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)deleteIdentityPolicyRequest.policyName()));
        }
        return request;
    }
}

