/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.transform.BodyUnmarshaller;
import software.amazon.awssdk.services.ses.transform.ContentUnmarshaller;

public class MessageUnmarshaller
implements Unmarshaller<Message, StaxUnmarshallerContext> {
    private static final MessageUnmarshaller INSTANCE = new MessageUnmarshaller();

    public Message unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Message.Builder message = Message.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Subject", targetDepth)) {
                    message.subject(ContentUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Body", targetDepth)) continue;
                message.body(BodyUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Message)message.build();
    }

    public static MessageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

