/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that a custom verification email template with the name you specified already exists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomVerificationEmailTemplateAlreadyExistsException extends SesException
        implements
        ToCopyableBuilder<CustomVerificationEmailTemplateAlreadyExistsException.Builder, CustomVerificationEmailTemplateAlreadyExistsException> {
    private final String customVerificationEmailTemplateName;

    private CustomVerificationEmailTemplateAlreadyExistsException(BuilderImpl builder) {
        super(builder);
        this.customVerificationEmailTemplateName = builder.customVerificationEmailTemplateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Indicates that the provided custom verification email template with the specified template name already exists.
     * </p>
     * 
     * @return Indicates that the provided custom verification email template with the specified template name already
     *         exists.
     */
    public String customVerificationEmailTemplateName() {
        return customVerificationEmailTemplateName;
    }

    public interface Builder extends CopyableBuilder<Builder, CustomVerificationEmailTemplateAlreadyExistsException>,
            SesException.Builder {
        /**
         * <p>
         * Indicates that the provided custom verification email template with the specified template name already
         * exists.
         * </p>
         * 
         * @param customVerificationEmailTemplateName
         *        Indicates that the provided custom verification email template with the specified template name
         *        already exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customVerificationEmailTemplateName(String customVerificationEmailTemplateName);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends SesException.BuilderImpl implements Builder {
        private String customVerificationEmailTemplateName;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomVerificationEmailTemplateAlreadyExistsException model) {
            super(model);
            customVerificationEmailTemplateName(model.customVerificationEmailTemplateName);
        }

        public final String getCustomVerificationEmailTemplateName() {
            return customVerificationEmailTemplateName;
        }

        @Override
        public final Builder customVerificationEmailTemplateName(String customVerificationEmailTemplateName) {
            this.customVerificationEmailTemplateName = customVerificationEmailTemplateName;
            return this;
        }

        public final void setCustomVerificationEmailTemplateName(String customVerificationEmailTemplateName) {
            this.customVerificationEmailTemplateName = customVerificationEmailTemplateName;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public CustomVerificationEmailTemplateAlreadyExistsException build() {
            return new CustomVerificationEmailTemplateAlreadyExistsException(this);
        }
    }
}
