/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to return the email sending status for your Amazon SES account in the current AWS Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountSendingEnabledResponse extends SesResponse implements
        ToCopyableBuilder<GetAccountSendingEnabledResponse.Builder, GetAccountSendingEnabledResponse> {
    private final Boolean enabled;

    private GetAccountSendingEnabledResponse(BuilderImpl builder) {
        super(builder);
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * Describes whether email sending is enabled or disabled for your Amazon SES account in the current AWS Region.
     * </p>
     * 
     * @return Describes whether email sending is enabled or disabled for your Amazon SES account in the current AWS
     *         Region.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSendingEnabledResponse)) {
            return false;
        }
        GetAccountSendingEnabledResponse other = (GetAccountSendingEnabledResponse) obj;
        return Objects.equals(enabled(), other.enabled());
    }

    @Override
    public String toString() {
        return ToString.builder("GetAccountSendingEnabledResponse").add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SesResponse.Builder, CopyableBuilder<Builder, GetAccountSendingEnabledResponse> {
        /**
         * <p>
         * Describes whether email sending is enabled or disabled for your Amazon SES account in the current AWS Region.
         * </p>
         * 
         * @param enabled
         *        Describes whether email sending is enabled or disabled for your Amazon SES account in the current AWS
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSendingEnabledResponse model) {
            super(model);
            enabled(model.enabled);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public GetAccountSendingEnabledResponse build() {
            return new GetAccountSendingEnabledResponse(this);
        }
    }
}
