/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the requested sending authorization policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityPoliciesResponse extends SesResponse implements
        ToCopyableBuilder<GetIdentityPoliciesResponse.Builder, GetIdentityPoliciesResponse> {
    private final Map<String, String> policies;

    private GetIdentityPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policies = builder.policies;
    }

    /**
     * <p>
     * A map of policy names to policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of policy names to policies.
     */
    public Map<String, String> policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoliciesResponse)) {
            return false;
        }
        GetIdentityPoliciesResponse other = (GetIdentityPoliciesResponse) obj;
        return Objects.equals(policies(), other.policies());
    }

    @Override
    public String toString() {
        return ToString.builder("GetIdentityPoliciesResponse").add("Policies", policies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SesResponse.Builder, CopyableBuilder<Builder, GetIdentityPoliciesResponse> {
        /**
         * <p>
         * A map of policy names to policies.
         * </p>
         * 
         * @param policies
         *        A map of policy names to policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Map<String, String> policies);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private Map<String, String> policies = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoliciesResponse model) {
            super(model);
            policies(model.policies);
        }

        public final Map<String, String> getPolicies() {
            return policies;
        }

        @Override
        public final Builder policies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
            return this;
        }

        public final void setPolicies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
        }

        @Override
        public GetIdentityPoliciesResponse build() {
            return new GetIdentityPoliciesResponse(this);
        }
    }
}
