/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A paginated list of custom verification email templates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomVerificationEmailTemplatesResponse extends SesResponse implements
        ToCopyableBuilder<ListCustomVerificationEmailTemplatesResponse.Builder, ListCustomVerificationEmailTemplatesResponse> {
    private final List<CustomVerificationEmailTemplate> customVerificationEmailTemplates;

    private final String nextToken;

    private ListCustomVerificationEmailTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.customVerificationEmailTemplates = builder.customVerificationEmailTemplates;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of the custom verification email templates that exist in your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the custom verification email templates that exist in your account.
     */
    public List<CustomVerificationEmailTemplate> customVerificationEmailTemplates() {
        return customVerificationEmailTemplates;
    }

    /**
     * <p>
     * A token indicating that there are additional custom verification email templates available to be listed. Pass
     * this token to a subsequent call to <code>ListTemplates</code> to retrieve the next 50 custom verification email
     * templates.
     * </p>
     * 
     * @return A token indicating that there are additional custom verification email templates available to be listed.
     *         Pass this token to a subsequent call to <code>ListTemplates</code> to retrieve the next 50 custom
     *         verification email templates.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customVerificationEmailTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomVerificationEmailTemplatesResponse)) {
            return false;
        }
        ListCustomVerificationEmailTemplatesResponse other = (ListCustomVerificationEmailTemplatesResponse) obj;
        return Objects.equals(customVerificationEmailTemplates(), other.customVerificationEmailTemplates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListCustomVerificationEmailTemplatesResponse")
                .add("CustomVerificationEmailTemplates", customVerificationEmailTemplates()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomVerificationEmailTemplates":
            return Optional.ofNullable(clazz.cast(customVerificationEmailTemplates()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SesResponse.Builder, CopyableBuilder<Builder, ListCustomVerificationEmailTemplatesResponse> {
        /**
         * <p>
         * A list of the custom verification email templates that exist in your account.
         * </p>
         * 
         * @param customVerificationEmailTemplates
         *        A list of the custom verification email templates that exist in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customVerificationEmailTemplates(Collection<CustomVerificationEmailTemplate> customVerificationEmailTemplates);

        /**
         * <p>
         * A list of the custom verification email templates that exist in your account.
         * </p>
         * 
         * @param customVerificationEmailTemplates
         *        A list of the custom verification email templates that exist in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customVerificationEmailTemplates(CustomVerificationEmailTemplate... customVerificationEmailTemplates);

        /**
         * <p>
         * A list of the custom verification email templates that exist in your account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomVerificationEmailTemplate>.Builder}
         * avoiding the need to create one manually via {@link List<CustomVerificationEmailTemplate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomVerificationEmailTemplate>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #customVerificationEmailTemplates(List<CustomVerificationEmailTemplate>)}.
         * 
         * @param customVerificationEmailTemplates
         *        a consumer that will call methods on {@link List<CustomVerificationEmailTemplate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customVerificationEmailTemplates(List<CustomVerificationEmailTemplate>)
         */
        Builder customVerificationEmailTemplates(
                Consumer<CustomVerificationEmailTemplate.Builder>... customVerificationEmailTemplates);

        /**
         * <p>
         * A token indicating that there are additional custom verification email templates available to be listed. Pass
         * this token to a subsequent call to <code>ListTemplates</code> to retrieve the next 50 custom verification
         * email templates.
         * </p>
         * 
         * @param nextToken
         *        A token indicating that there are additional custom verification email templates available to be
         *        listed. Pass this token to a subsequent call to <code>ListTemplates</code> to retrieve the next 50
         *        custom verification email templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private List<CustomVerificationEmailTemplate> customVerificationEmailTemplates = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomVerificationEmailTemplatesResponse model) {
            super(model);
            customVerificationEmailTemplates(model.customVerificationEmailTemplates);
            nextToken(model.nextToken);
        }

        public final Collection<CustomVerificationEmailTemplate.Builder> getCustomVerificationEmailTemplates() {
            return customVerificationEmailTemplates != null ? customVerificationEmailTemplates.stream()
                    .map(CustomVerificationEmailTemplate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customVerificationEmailTemplates(
                Collection<CustomVerificationEmailTemplate> customVerificationEmailTemplates) {
            this.customVerificationEmailTemplates = CustomVerificationEmailTemplatesCopier.copy(customVerificationEmailTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVerificationEmailTemplates(CustomVerificationEmailTemplate... customVerificationEmailTemplates) {
            customVerificationEmailTemplates(Arrays.asList(customVerificationEmailTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVerificationEmailTemplates(
                Consumer<CustomVerificationEmailTemplate.Builder>... customVerificationEmailTemplates) {
            customVerificationEmailTemplates(Stream.of(customVerificationEmailTemplates)
                    .map(c -> CustomVerificationEmailTemplate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomVerificationEmailTemplates(
                Collection<CustomVerificationEmailTemplate.BuilderImpl> customVerificationEmailTemplates) {
            this.customVerificationEmailTemplates = CustomVerificationEmailTemplatesCopier
                    .copyFromBuilder(customVerificationEmailTemplates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCustomVerificationEmailTemplatesResponse build() {
            return new ListCustomVerificationEmailTemplatesResponse(this);
        }
    }
}
