/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the topic ARN associated with an Amazon Simple Notification Service (Amazon SNS) event destination.
 * </p>
 * <p>
 * Event destinations, such as Amazon SNS, are associated with configuration sets, which enable you to publish email
 * sending events. For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SNSDestination implements ToCopyableBuilder<SNSDestination.Builder, SNSDestination> {
    private final String topicARN;

    private SNSDestination(BuilderImpl builder) {
        this.topicARN = builder.topicARN;
    }

    /**
     * <p>
     * The ARN of the Amazon SNS topic that email sending events will be published to. An example of an Amazon SNS topic
     * ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about Amazon SNS topics, see
     * the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
     * </p>
     * 
     * @return The ARN of the Amazon SNS topic that email sending events will be published to. An example of an Amazon
     *         SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
     *         Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS
     *         Developer Guide</a>.
     */
    public String topicARN() {
        return topicARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNSDestination)) {
            return false;
        }
        SNSDestination other = (SNSDestination) obj;
        return Objects.equals(topicARN(), other.topicARN());
    }

    @Override
    public String toString() {
        return ToString.builder("SNSDestination").add("TopicARN", topicARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicARN":
            return Optional.ofNullable(clazz.cast(topicARN()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SNSDestination> {
        /**
         * <p>
         * The ARN of the Amazon SNS topic that email sending events will be published to. An example of an Amazon SNS
         * topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about Amazon SNS
         * topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer
         * Guide</a>.
         * </p>
         * 
         * @param topicARN
         *        The ARN of the Amazon SNS topic that email sending events will be published to. An example of an
         *        Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information
         *        about Amazon SNS topics, see the <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicARN(String topicARN);
    }

    static final class BuilderImpl implements Builder {
        private String topicARN;

        private BuilderImpl() {
        }

        private BuilderImpl(SNSDestination model) {
            topicARN(model.topicARN);
        }

        public final String getTopicARN() {
            return topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        @Override
        public SNSDestination build() {
            return new SNSDestination(this);
        }
    }
}
