/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to send a custom verification email to a specified recipient.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendCustomVerificationEmailRequest extends SesRequest implements
        ToCopyableBuilder<SendCustomVerificationEmailRequest.Builder, SendCustomVerificationEmailRequest> {
    private final String emailAddress;

    private final String templateName;

    private final String configurationSetName;

    private SendCustomVerificationEmailRequest(BuilderImpl builder) {
        super(builder);
        this.emailAddress = builder.emailAddress;
        this.templateName = builder.templateName;
        this.configurationSetName = builder.configurationSetName;
    }

    /**
     * <p>
     * The email address to verify.
     * </p>
     * 
     * @return The email address to verify.
     */
    public String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The name of the custom verification email template to use when sending the verification email.
     * </p>
     * 
     * @return The name of the custom verification email template to use when sending the verification email.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * Name of a configuration set to use when sending the verification email.
     * </p>
     * 
     * @return Name of a configuration set to use when sending the verification email.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCustomVerificationEmailRequest)) {
            return false;
        }
        SendCustomVerificationEmailRequest other = (SendCustomVerificationEmailRequest) obj;
        return Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(configurationSetName(), other.configurationSetName());
    }

    @Override
    public String toString() {
        return ToString.builder("SendCustomVerificationEmailRequest").add("EmailAddress", emailAddress())
                .add("TemplateName", templateName()).add("ConfigurationSetName", configurationSetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SesRequest.Builder, CopyableBuilder<Builder, SendCustomVerificationEmailRequest> {
        /**
         * <p>
         * The email address to verify.
         * </p>
         * 
         * @param emailAddress
         *        The email address to verify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The name of the custom verification email template to use when sending the verification email.
         * </p>
         * 
         * @param templateName
         *        The name of the custom verification email template to use when sending the verification email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * Name of a configuration set to use when sending the verification email.
         * </p>
         * 
         * @param configurationSetName
         *        Name of a configuration set to use when sending the verification email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String emailAddress;

        private String templateName;

        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCustomVerificationEmailRequest model) {
            super(model);
            emailAddress(model.emailAddress);
            templateName(model.templateName);
            configurationSetName(model.configurationSetName);
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendCustomVerificationEmailRequest build() {
            return new SendCustomVerificationEmailRequest(this);
        }
    }
}
