/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the TrackingOptions object you specified does not exist.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrackingOptionsDoesNotExistException extends SesException implements
        ToCopyableBuilder<TrackingOptionsDoesNotExistException.Builder, TrackingOptionsDoesNotExistException> {
    private final String configurationSetName;

    private TrackingOptionsDoesNotExistException(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Indicates that a TrackingOptions object does not exist in the specified configuration set.
     * </p>
     * 
     * @return Indicates that a TrackingOptions object does not exist in the specified configuration set.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    public interface Builder extends CopyableBuilder<Builder, TrackingOptionsDoesNotExistException>, SesException.Builder {
        /**
         * <p>
         * Indicates that a TrackingOptions object does not exist in the specified configuration set.
         * </p>
         * 
         * @param configurationSetName
         *        Indicates that a TrackingOptions object does not exist in the specified configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends SesException.BuilderImpl implements Builder {
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingOptionsDoesNotExistException model) {
            super(model);
            configurationSetName(model.configurationSetName);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public TrackingOptionsDoesNotExistException build() {
            return new TrackingOptionsDoesNotExistException(this);
        }
    }
}
