/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * CreateConfigurationSetEventDestinationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateConfigurationSetEventDestinationRequestMarshaller implements
        Marshaller<Request<CreateConfigurationSetEventDestinationRequest>, CreateConfigurationSetEventDestinationRequest> {

    public Request<CreateConfigurationSetEventDestinationRequest> marshall(
            CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {

        if (createConfigurationSetEventDestinationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateConfigurationSetEventDestinationRequest> request = new DefaultRequest<CreateConfigurationSetEventDestinationRequest>(
                createConfigurationSetEventDestinationRequest, "SesClient");
        request.addParameter("Action", "CreateConfigurationSetEventDestination");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (createConfigurationSetEventDestinationRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName",
                    StringConversion.fromString(createConfigurationSetEventDestinationRequest.configurationSetName()));
        }

        EventDestination eventDestination = createConfigurationSetEventDestinationRequest.eventDestination();
        if (eventDestination != null) {

            if (eventDestination.name() != null) {
                request.addParameter("EventDestination.Name", StringConversion.fromString(eventDestination.name()));
            }

            if (eventDestination.enabled() != null) {
                request.addParameter("EventDestination.Enabled", StringConversion.fromBoolean(eventDestination.enabled()));
            }

            if (eventDestination.matchingEventTypesAsStrings().isEmpty()
                    && !(eventDestination.matchingEventTypesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("EventDestination.MatchingEventTypes", "");
            } else if (!eventDestination.matchingEventTypesAsStrings().isEmpty()
                    && !(eventDestination.matchingEventTypesAsStrings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> matchingEventTypesList = eventDestination.matchingEventTypesAsStrings();
                int matchingEventTypesListIndex = 1;

                for (String matchingEventTypesListValue : matchingEventTypesList) {
                    if (matchingEventTypesListValue != null) {
                        request.addParameter("EventDestination.MatchingEventTypes.member." + matchingEventTypesListIndex,
                                StringConversion.fromString(matchingEventTypesListValue));
                    }
                    matchingEventTypesListIndex++;
                }
            }

            KinesisFirehoseDestination kinesisFirehoseDestination = eventDestination.kinesisFirehoseDestination();
            if (kinesisFirehoseDestination != null) {

                if (kinesisFirehoseDestination.iamRoleARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.IAMRoleARN",
                            StringConversion.fromString(kinesisFirehoseDestination.iamRoleARN()));
                }

                if (kinesisFirehoseDestination.deliveryStreamARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.DeliveryStreamARN",
                            StringConversion.fromString(kinesisFirehoseDestination.deliveryStreamARN()));
                }
            }

            CloudWatchDestination cloudWatchDestination = eventDestination.cloudWatchDestination();
            if (cloudWatchDestination != null) {

                if (cloudWatchDestination.dimensionConfigurations().isEmpty()
                        && !(cloudWatchDestination.dimensionConfigurations() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations", "");
                } else if (!cloudWatchDestination.dimensionConfigurations().isEmpty()
                        && !(cloudWatchDestination.dimensionConfigurations() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    java.util.List<CloudWatchDimensionConfiguration> dimensionConfigurationsList = cloudWatchDestination
                            .dimensionConfigurations();
                    int dimensionConfigurationsListIndex = 1;

                    for (CloudWatchDimensionConfiguration dimensionConfigurationsListValue : dimensionConfigurationsList) {

                        if (dimensionConfigurationsListValue.dimensionName() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member."
                                    + dimensionConfigurationsListIndex + ".DimensionName",
                                    StringConversion.fromString(dimensionConfigurationsListValue.dimensionName()));
                        }

                        if (dimensionConfigurationsListValue.dimensionValueSourceAsString() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member."
                                    + dimensionConfigurationsListIndex + ".DimensionValueSource",
                                    StringConversion.fromString(dimensionConfigurationsListValue.dimensionValueSourceAsString()));
                        }

                        if (dimensionConfigurationsListValue.defaultDimensionValue() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member."
                                    + dimensionConfigurationsListIndex + ".DefaultDimensionValue",
                                    StringConversion.fromString(dimensionConfigurationsListValue.defaultDimensionValue()));
                        }
                        dimensionConfigurationsListIndex++;
                    }
                }
            }

            SNSDestination snsDestination = eventDestination.snsDestination();
            if (snsDestination != null) {

                if (snsDestination.topicARN() != null) {
                    request.addParameter("EventDestination.SNSDestination.TopicARN",
                            StringConversion.fromString(snsDestination.topicARN()));
                }
            }
        }

        return request;
    }

}
