/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * CreateCustomVerificationEmailTemplateRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateCustomVerificationEmailTemplateRequestMarshaller implements
        Marshaller<Request<CreateCustomVerificationEmailTemplateRequest>, CreateCustomVerificationEmailTemplateRequest> {

    public Request<CreateCustomVerificationEmailTemplateRequest> marshall(
            CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest) {

        if (createCustomVerificationEmailTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateCustomVerificationEmailTemplateRequest> request = new DefaultRequest<CreateCustomVerificationEmailTemplateRequest>(
                createCustomVerificationEmailTemplateRequest, "SesClient");
        request.addParameter("Action", "CreateCustomVerificationEmailTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (createCustomVerificationEmailTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName",
                    StringConversion.fromString(createCustomVerificationEmailTemplateRequest.templateName()));
        }

        if (createCustomVerificationEmailTemplateRequest.fromEmailAddress() != null) {
            request.addParameter("FromEmailAddress",
                    StringConversion.fromString(createCustomVerificationEmailTemplateRequest.fromEmailAddress()));
        }

        if (createCustomVerificationEmailTemplateRequest.templateSubject() != null) {
            request.addParameter("TemplateSubject",
                    StringConversion.fromString(createCustomVerificationEmailTemplateRequest.templateSubject()));
        }

        if (createCustomVerificationEmailTemplateRequest.templateContent() != null) {
            request.addParameter("TemplateContent",
                    StringConversion.fromString(createCustomVerificationEmailTemplateRequest.templateContent()));
        }

        if (createCustomVerificationEmailTemplateRequest.successRedirectionURL() != null) {
            request.addParameter("SuccessRedirectionURL",
                    StringConversion.fromString(createCustomVerificationEmailTemplateRequest.successRedirectionURL()));
        }

        if (createCustomVerificationEmailTemplateRequest.failureRedirectionURL() != null) {
            request.addParameter("FailureRedirectionURL",
                    StringConversion.fromString(createCustomVerificationEmailTemplateRequest.failureRedirectionURL()));
        }

        return request;
    }

}
