/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.Map;
import java.util.HashMap;

import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapEntry;

/**
 * GetIdentityMailFromDomainAttributesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetIdentityMailFromDomainAttributesResponseUnmarshaller implements
        Unmarshaller<GetIdentityMailFromDomainAttributesResponse, StaxUnmarshallerContext> {

    private static class MailFromDomainAttributesMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, IdentityMailFromDomainAttributes>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, IdentityMailFromDomainAttributes> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, IdentityMailFromDomainAttributes> entry = new MapEntry<String, IdentityMailFromDomainAttributes>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(IdentityMailFromDomainAttributesUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final MailFromDomainAttributesMapEntryUnmarshaller INSTANCE = new MailFromDomainAttributesMapEntryUnmarshaller();

        public static MailFromDomainAttributesMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    public GetIdentityMailFromDomainAttributesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetIdentityMailFromDomainAttributesResponse.Builder getIdentityMailFromDomainAttributesResponse = GetIdentityMailFromDomainAttributesResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                getIdentityMailFromDomainAttributesResponse.mailFromDomainAttributes(mailFromDomainAttributes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("MailFromDomainAttributes/entry", targetDepth)) {
                    if (mailFromDomainAttributes == null) {
                        mailFromDomainAttributes = new java.util.HashMap<>();
                    }
                    Entry<String, IdentityMailFromDomainAttributes> entry = MailFromDomainAttributesMapEntryUnmarshaller
                            .getInstance().unmarshall(context);
                    // getIdentityMailFromDomainAttributesResponse.addMailFromDomainAttributesEntry(entry.getKey(),
                    // entry.getValue());

                    mailFromDomainAttributes.put(entry.getKey(), entry.getValue());
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    getIdentityMailFromDomainAttributesResponse.mailFromDomainAttributes(mailFromDomainAttributes);
                    break;
                }
            }
        }
        return getIdentityMailFromDomainAttributesResponse.build();
    }

    private static final GetIdentityMailFromDomainAttributesResponseUnmarshaller INSTANCE = new GetIdentityMailFromDomainAttributesResponseUnmarshaller();

    public static GetIdentityMailFromDomainAttributesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
