/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * SendCustomVerificationEmailRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendCustomVerificationEmailRequestMarshaller implements
        Marshaller<Request<SendCustomVerificationEmailRequest>, SendCustomVerificationEmailRequest> {

    public Request<SendCustomVerificationEmailRequest> marshall(
            SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) {

        if (sendCustomVerificationEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<SendCustomVerificationEmailRequest> request = new DefaultRequest<SendCustomVerificationEmailRequest>(
                sendCustomVerificationEmailRequest, "SesClient");
        request.addParameter("Action", "SendCustomVerificationEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendCustomVerificationEmailRequest.emailAddress() != null) {
            request.addParameter("EmailAddress", StringConversion.fromString(sendCustomVerificationEmailRequest.emailAddress()));
        }

        if (sendCustomVerificationEmailRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString(sendCustomVerificationEmailRequest.templateName()));
        }

        if (sendCustomVerificationEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName",
                    StringConversion.fromString(sendCustomVerificationEmailRequest.configurationSetName()));
        }

        return request;
    }

}
