/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * SendEmailRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendEmailRequestMarshaller implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {

    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {

        if (sendEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<SendEmailRequest> request = new DefaultRequest<SendEmailRequest>(sendEmailRequest, "SesClient");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendEmailRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString(sendEmailRequest.source()));
        }

        Destination destination = sendEmailRequest.destination();
        if (destination != null) {

            if (destination.toAddresses().isEmpty()
                    && !(destination.toAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("Destination.ToAddresses", "");
            } else if (!destination.toAddresses().isEmpty()
                    && !(destination.toAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> toAddressesList = destination.toAddresses();
                int toAddressesListIndex = 1;

                for (String toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex,
                                StringConversion.fromString(toAddressesListValue));
                    }
                    toAddressesListIndex++;
                }
            }

            if (destination.ccAddresses().isEmpty()
                    && !(destination.ccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("Destination.CcAddresses", "");
            } else if (!destination.ccAddresses().isEmpty()
                    && !(destination.ccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> ccAddressesList = destination.ccAddresses();
                int ccAddressesListIndex = 1;

                for (String ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex,
                                StringConversion.fromString(ccAddressesListValue));
                    }
                    ccAddressesListIndex++;
                }
            }

            if (destination.bccAddresses().isEmpty()
                    && !(destination.bccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("Destination.BccAddresses", "");
            } else if (!destination.bccAddresses().isEmpty()
                    && !(destination.bccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> bccAddressesList = destination.bccAddresses();
                int bccAddressesListIndex = 1;

                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex,
                                StringConversion.fromString(bccAddressesListValue));
                    }
                    bccAddressesListIndex++;
                }
            }
        }

        Message message = sendEmailRequest.message();
        if (message != null) {

            Content subject = message.subject();
            if (subject != null) {

                if (subject.data() != null) {
                    request.addParameter("Message.Subject.Data", StringConversion.fromString(subject.data()));
                }

                if (subject.charset() != null) {
                    request.addParameter("Message.Subject.Charset", StringConversion.fromString(subject.charset()));
                }
            }

            Body body = message.body();
            if (body != null) {

                Content text = body.text();
                if (text != null) {

                    if (text.data() != null) {
                        request.addParameter("Message.Body.Text.Data", StringConversion.fromString(text.data()));
                    }

                    if (text.charset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringConversion.fromString(text.charset()));
                    }
                }

                Content html = body.html();
                if (html != null) {

                    if (html.data() != null) {
                        request.addParameter("Message.Body.Html.Data", StringConversion.fromString(html.data()));
                    }

                    if (html.charset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringConversion.fromString(html.charset()));
                    }
                }
            }
        }

        if (sendEmailRequest.replyToAddresses().isEmpty()
                && !(sendEmailRequest.replyToAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ReplyToAddresses", "");
        } else if (!sendEmailRequest.replyToAddresses().isEmpty()
                && !(sendEmailRequest.replyToAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> replyToAddressesList = sendEmailRequest.replyToAddresses();
            int replyToAddressesListIndex = 1;

            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex,
                            StringConversion.fromString(replyToAddressesListValue));
                }
                replyToAddressesListIndex++;
            }
        }

        if (sendEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringConversion.fromString(sendEmailRequest.returnPath()));
        }

        if (sendEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringConversion.fromString(sendEmailRequest.sourceArn()));
        }

        if (sendEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringConversion.fromString(sendEmailRequest.returnPathArn()));
        }

        if (sendEmailRequest.tags().isEmpty()
                && !(sendEmailRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!sendEmailRequest.tags().isEmpty()
                && !(sendEmailRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<MessageTag> tagsList = sendEmailRequest.tags();
            int tagsListIndex = 1;

            for (MessageTag tagsListValue : tagsList) {

                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name",
                            StringConversion.fromString(tagsListValue.name()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (sendEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringConversion.fromString(sendEmailRequest.configurationSetName()));
        }

        return request;
    }

}
