/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * UpdateConfigurationSetTrackingOptionsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateConfigurationSetTrackingOptionsRequestMarshaller implements
        Marshaller<Request<UpdateConfigurationSetTrackingOptionsRequest>, UpdateConfigurationSetTrackingOptionsRequest> {

    public Request<UpdateConfigurationSetTrackingOptionsRequest> marshall(
            UpdateConfigurationSetTrackingOptionsRequest updateConfigurationSetTrackingOptionsRequest) {

        if (updateConfigurationSetTrackingOptionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateConfigurationSetTrackingOptionsRequest> request = new DefaultRequest<UpdateConfigurationSetTrackingOptionsRequest>(
                updateConfigurationSetTrackingOptionsRequest, "SesClient");
        request.addParameter("Action", "UpdateConfigurationSetTrackingOptions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateConfigurationSetTrackingOptionsRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName",
                    StringConversion.fromString(updateConfigurationSetTrackingOptionsRequest.configurationSetName()));
        }

        TrackingOptions trackingOptions = updateConfigurationSetTrackingOptionsRequest.trackingOptions();
        if (trackingOptions != null) {

            if (trackingOptions.customRedirectDomain() != null) {
                request.addParameter("TrackingOptions.CustomRedirectDomain",
                        StringConversion.fromString(trackingOptions.customRedirectDomain()));
            }
        }

        return request;
    }

}
