/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * UpdateCustomVerificationEmailTemplateRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateCustomVerificationEmailTemplateRequestMarshaller implements
        Marshaller<Request<UpdateCustomVerificationEmailTemplateRequest>, UpdateCustomVerificationEmailTemplateRequest> {

    public Request<UpdateCustomVerificationEmailTemplateRequest> marshall(
            UpdateCustomVerificationEmailTemplateRequest updateCustomVerificationEmailTemplateRequest) {

        if (updateCustomVerificationEmailTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateCustomVerificationEmailTemplateRequest> request = new DefaultRequest<UpdateCustomVerificationEmailTemplateRequest>(
                updateCustomVerificationEmailTemplateRequest, "SesClient");
        request.addParameter("Action", "UpdateCustomVerificationEmailTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateCustomVerificationEmailTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName",
                    StringConversion.fromString(updateCustomVerificationEmailTemplateRequest.templateName()));
        }

        if (updateCustomVerificationEmailTemplateRequest.fromEmailAddress() != null) {
            request.addParameter("FromEmailAddress",
                    StringConversion.fromString(updateCustomVerificationEmailTemplateRequest.fromEmailAddress()));
        }

        if (updateCustomVerificationEmailTemplateRequest.templateSubject() != null) {
            request.addParameter("TemplateSubject",
                    StringConversion.fromString(updateCustomVerificationEmailTemplateRequest.templateSubject()));
        }

        if (updateCustomVerificationEmailTemplateRequest.templateContent() != null) {
            request.addParameter("TemplateContent",
                    StringConversion.fromString(updateCustomVerificationEmailTemplateRequest.templateContent()));
        }

        if (updateCustomVerificationEmailTemplateRequest.successRedirectionURL() != null) {
            request.addParameter("SuccessRedirectionURL",
                    StringConversion.fromString(updateCustomVerificationEmailTemplateRequest.successRedirectionURL()));
        }

        if (updateCustomVerificationEmailTemplateRequest.failureRedirectionURL() != null) {
            request.addParameter("FailureRedirectionURL",
                    StringConversion.fromString(updateCustomVerificationEmailTemplateRequest.failureRedirectionURL()));
        }

        return request;
    }

}
