/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * UpdateReceiptRuleRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateReceiptRuleRequestMarshaller implements
        Marshaller<Request<UpdateReceiptRuleRequest>, UpdateReceiptRuleRequest> {

    public Request<UpdateReceiptRuleRequest> marshall(UpdateReceiptRuleRequest updateReceiptRuleRequest) {

        if (updateReceiptRuleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateReceiptRuleRequest> request = new DefaultRequest<UpdateReceiptRuleRequest>(updateReceiptRuleRequest,
                "SesClient");
        request.addParameter("Action", "UpdateReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateReceiptRuleRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringConversion.fromString(updateReceiptRuleRequest.ruleSetName()));
        }

        ReceiptRule rule = updateReceiptRuleRequest.rule();
        if (rule != null) {

            if (rule.name() != null) {
                request.addParameter("Rule.Name", StringConversion.fromString(rule.name()));
            }

            if (rule.enabled() != null) {
                request.addParameter("Rule.Enabled", StringConversion.fromBoolean(rule.enabled()));
            }

            if (rule.tlsPolicyAsString() != null) {
                request.addParameter("Rule.TlsPolicy", StringConversion.fromString(rule.tlsPolicyAsString()));
            }

            if (rule.recipients().isEmpty()
                    && !(rule.recipients() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("Rule.Recipients", "");
            } else if (!rule.recipients().isEmpty()
                    && !(rule.recipients() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> recipientsList = rule.recipients();
                int recipientsListIndex = 1;

                for (String recipientsListValue : recipientsList) {
                    if (recipientsListValue != null) {
                        request.addParameter("Rule.Recipients.member." + recipientsListIndex,
                                StringConversion.fromString(recipientsListValue));
                    }
                    recipientsListIndex++;
                }
            }

            if (rule.actions().isEmpty() && !(rule.actions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("Rule.Actions", "");
            } else if (!rule.actions().isEmpty()
                    && !(rule.actions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<ReceiptAction> actionsList = rule.actions();
                int actionsListIndex = 1;

                for (ReceiptAction actionsListValue : actionsList) {

                    S3Action s3Action = actionsListValue.s3Action();
                    if (s3Action != null) {

                        if (s3Action.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.TopicArn",
                                    StringConversion.fromString(s3Action.topicArn()));
                        }

                        if (s3Action.bucketName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.BucketName",
                                    StringConversion.fromString(s3Action.bucketName()));
                        }

                        if (s3Action.objectKeyPrefix() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.ObjectKeyPrefix",
                                    StringConversion.fromString(s3Action.objectKeyPrefix()));
                        }

                        if (s3Action.kmsKeyArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.KmsKeyArn",
                                    StringConversion.fromString(s3Action.kmsKeyArn()));
                        }
                    }

                    BounceAction bounceAction = actionsListValue.bounceAction();
                    if (bounceAction != null) {

                        if (bounceAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.TopicArn",
                                    StringConversion.fromString(bounceAction.topicArn()));
                        }

                        if (bounceAction.smtpReplyCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.SmtpReplyCode",
                                    StringConversion.fromString(bounceAction.smtpReplyCode()));
                        }

                        if (bounceAction.statusCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.StatusCode",
                                    StringConversion.fromString(bounceAction.statusCode()));
                        }

                        if (bounceAction.message() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Message",
                                    StringConversion.fromString(bounceAction.message()));
                        }

                        if (bounceAction.sender() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Sender",
                                    StringConversion.fromString(bounceAction.sender()));
                        }
                    }

                    WorkmailAction workmailAction = actionsListValue.workmailAction();
                    if (workmailAction != null) {

                        if (workmailAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.TopicArn",
                                    StringConversion.fromString(workmailAction.topicArn()));
                        }

                        if (workmailAction.organizationArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.OrganizationArn",
                                    StringConversion.fromString(workmailAction.organizationArn()));
                        }
                    }

                    LambdaAction lambdaAction = actionsListValue.lambdaAction();
                    if (lambdaAction != null) {

                        if (lambdaAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.TopicArn",
                                    StringConversion.fromString(lambdaAction.topicArn()));
                        }

                        if (lambdaAction.functionArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.FunctionArn",
                                    StringConversion.fromString(lambdaAction.functionArn()));
                        }

                        if (lambdaAction.invocationTypeAsString() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.InvocationType",
                                    StringConversion.fromString(lambdaAction.invocationTypeAsString()));
                        }
                    }

                    StopAction stopAction = actionsListValue.stopAction();
                    if (stopAction != null) {

                        if (stopAction.scopeAsString() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.Scope",
                                    StringConversion.fromString(stopAction.scopeAsString()));
                        }

                        if (stopAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.TopicArn",
                                    StringConversion.fromString(stopAction.topicArn()));
                        }
                    }

                    AddHeaderAction addHeaderAction = actionsListValue.addHeaderAction();
                    if (addHeaderAction != null) {

                        if (addHeaderAction.headerName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderName",
                                    StringConversion.fromString(addHeaderAction.headerName()));
                        }

                        if (addHeaderAction.headerValue() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderValue",
                                    StringConversion.fromString(addHeaderAction.headerValue()));
                        }
                    }

                    SNSAction snsAction = actionsListValue.snsAction();
                    if (snsAction != null) {

                        if (snsAction.topicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.TopicArn",
                                    StringConversion.fromString(snsAction.topicArn()));
                        }

                        if (snsAction.encodingAsString() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.Encoding",
                                    StringConversion.fromString(snsAction.encodingAsString()));
                        }
                    }
                    actionsListIndex++;
                }
            }

            if (rule.scanEnabled() != null) {
                request.addParameter("Rule.ScanEnabled", StringConversion.fromBoolean(rule.scanEnabled()));
            }
        }

        return request;
    }

}
