/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchDestination
implements ToCopyableBuilder<Builder, CloudWatchDestination> {
    private final List<CloudWatchDimensionConfiguration> dimensionConfigurations;

    private CloudWatchDestination(BuilderImpl builder) {
        this.dimensionConfigurations = builder.dimensionConfigurations;
    }

    public List<CloudWatchDimensionConfiguration> dimensionConfigurations() {
        return this.dimensionConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDestination)) {
            return false;
        }
        CloudWatchDestination other = (CloudWatchDestination)obj;
        return Objects.equals(this.dimensionConfigurations(), other.dimensionConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchDestination").add("DimensionConfigurations", this.dimensionConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionConfigurations": {
                return Optional.ofNullable(clazz.cast(this.dimensionConfigurations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<CloudWatchDimensionConfiguration> dimensionConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchDestination model) {
            this.dimensionConfigurations(model.dimensionConfigurations);
        }

        public final Collection<CloudWatchDimensionConfiguration.Builder> getDimensionConfigurations() {
            return this.dimensionConfigurations != null ? (Collection)this.dimensionConfigurations.stream().map(CloudWatchDimensionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copy(dimensionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(CloudWatchDimensionConfiguration ... dimensionConfigurations) {
            this.dimensionConfigurations(Arrays.asList(dimensionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(Consumer<CloudWatchDimensionConfiguration.Builder> ... dimensionConfigurations) {
            this.dimensionConfigurations(Stream.of(dimensionConfigurations).map(c -> (CloudWatchDimensionConfiguration)((CloudWatchDimensionConfiguration.Builder)CloudWatchDimensionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensionConfigurations(Collection<CloudWatchDimensionConfiguration.BuilderImpl> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copyFromBuilder(dimensionConfigurations);
        }

        public CloudWatchDestination build() {
            return new CloudWatchDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchDestination> {
        public Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> var1);

        public Builder dimensionConfigurations(CloudWatchDimensionConfiguration ... var1);

        public Builder dimensionConfigurations(Consumer<CloudWatchDimensionConfiguration.Builder> ... var1);
    }
}

