/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure;
import software.amazon.awssdk.services.ses.model.CustomMailFromStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityMailFromDomainAttributes
implements ToCopyableBuilder<Builder, IdentityMailFromDomainAttributes> {
    private final String mailFromDomain;
    private final String mailFromDomainStatus;
    private final String behaviorOnMXFailure;

    private IdentityMailFromDomainAttributes(BuilderImpl builder) {
        this.mailFromDomain = builder.mailFromDomain;
        this.mailFromDomainStatus = builder.mailFromDomainStatus;
        this.behaviorOnMXFailure = builder.behaviorOnMXFailure;
    }

    public String mailFromDomain() {
        return this.mailFromDomain;
    }

    public CustomMailFromStatus mailFromDomainStatus() {
        return CustomMailFromStatus.fromValue(this.mailFromDomainStatus);
    }

    public String mailFromDomainStatusAsString() {
        return this.mailFromDomainStatus;
    }

    public BehaviorOnMXFailure behaviorOnMXFailure() {
        return BehaviorOnMXFailure.fromValue(this.behaviorOnMXFailure);
    }

    public String behaviorOnMXFailureAsString() {
        return this.behaviorOnMXFailure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromDomainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorOnMXFailureAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityMailFromDomainAttributes)) {
            return false;
        }
        IdentityMailFromDomainAttributes other = (IdentityMailFromDomainAttributes)obj;
        return Objects.equals(this.mailFromDomain(), other.mailFromDomain()) && Objects.equals(this.mailFromDomainStatusAsString(), other.mailFromDomainStatusAsString()) && Objects.equals(this.behaviorOnMXFailureAsString(), other.behaviorOnMXFailureAsString());
    }

    public String toString() {
        return ToString.builder((String)"IdentityMailFromDomainAttributes").add("MailFromDomain", (Object)this.mailFromDomain()).add("MailFromDomainStatus", (Object)this.mailFromDomainStatusAsString()).add("BehaviorOnMXFailure", (Object)this.behaviorOnMXFailureAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MailFromDomain": {
                return Optional.ofNullable(clazz.cast(this.mailFromDomain()));
            }
            case "MailFromDomainStatus": {
                return Optional.ofNullable(clazz.cast(this.mailFromDomainStatusAsString()));
            }
            case "BehaviorOnMXFailure": {
                return Optional.ofNullable(clazz.cast(this.behaviorOnMXFailureAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String mailFromDomain;
        private String mailFromDomainStatus;
        private String behaviorOnMXFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityMailFromDomainAttributes model) {
            this.mailFromDomain(model.mailFromDomain);
            this.mailFromDomainStatus(model.mailFromDomainStatus);
            this.behaviorOnMXFailure(model.behaviorOnMXFailure);
        }

        public final String getMailFromDomain() {
            return this.mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        public final String getMailFromDomainStatus() {
            return this.mailFromDomainStatus;
        }

        @Override
        public final Builder mailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
            return this;
        }

        @Override
        public final Builder mailFromDomainStatus(CustomMailFromStatus mailFromDomainStatus) {
            this.mailFromDomainStatus(mailFromDomainStatus.toString());
            return this;
        }

        public final void setMailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
        }

        public final String getBehaviorOnMXFailure() {
            return this.behaviorOnMXFailure;
        }

        @Override
        public final Builder behaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure) {
            this.behaviorOnMXFailure(behaviorOnMXFailure.toString());
            return this;
        }

        public final void setBehaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
        }

        public IdentityMailFromDomainAttributes build() {
            return new IdentityMailFromDomainAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityMailFromDomainAttributes> {
        public Builder mailFromDomain(String var1);

        public Builder mailFromDomainStatus(String var1);

        public Builder mailFromDomainStatus(CustomMailFromStatus var1);

        public Builder behaviorOnMXFailure(String var1);

        public Builder behaviorOnMXFailure(BehaviorOnMXFailure var1);
    }
}

