/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomVerificationEmailTemplateRequest
extends SesRequest
implements ToCopyableBuilder<Builder, UpdateCustomVerificationEmailTemplateRequest> {
    private final String templateName;
    private final String fromEmailAddress;
    private final String templateSubject;
    private final String templateContent;
    private final String successRedirectionURL;
    private final String failureRedirectionURL;

    private UpdateCustomVerificationEmailTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.templateSubject = builder.templateSubject;
        this.templateContent = builder.templateContent;
        this.successRedirectionURL = builder.successRedirectionURL;
        this.failureRedirectionURL = builder.failureRedirectionURL;
    }

    public String templateName() {
        return this.templateName;
    }

    public String fromEmailAddress() {
        return this.fromEmailAddress;
    }

    public String templateSubject() {
        return this.templateSubject;
    }

    public String templateContent() {
        return this.templateContent;
    }

    public String successRedirectionURL() {
        return this.successRedirectionURL;
    }

    public String failureRedirectionURL() {
        return this.failureRedirectionURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.successRedirectionURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureRedirectionURL());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomVerificationEmailTemplateRequest)) {
            return false;
        }
        UpdateCustomVerificationEmailTemplateRequest other = (UpdateCustomVerificationEmailTemplateRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.fromEmailAddress(), other.fromEmailAddress()) && Objects.equals(this.templateSubject(), other.templateSubject()) && Objects.equals(this.templateContent(), other.templateContent()) && Objects.equals(this.successRedirectionURL(), other.successRedirectionURL()) && Objects.equals(this.failureRedirectionURL(), other.failureRedirectionURL());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCustomVerificationEmailTemplateRequest").add("TemplateName", (Object)this.templateName()).add("FromEmailAddress", (Object)this.fromEmailAddress()).add("TemplateSubject", (Object)this.templateSubject()).add("TemplateContent", (Object)this.templateContent()).add("SuccessRedirectionURL", (Object)this.successRedirectionURL()).add("FailureRedirectionURL", (Object)this.failureRedirectionURL()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "FromEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddress()));
            }
            case "TemplateSubject": {
                return Optional.ofNullable(clazz.cast(this.templateSubject()));
            }
            case "TemplateContent": {
                return Optional.ofNullable(clazz.cast(this.templateContent()));
            }
            case "SuccessRedirectionURL": {
                return Optional.ofNullable(clazz.cast(this.successRedirectionURL()));
            }
            case "FailureRedirectionURL": {
                return Optional.ofNullable(clazz.cast(this.failureRedirectionURL()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String templateName;
        private String fromEmailAddress;
        private String templateSubject;
        private String templateContent;
        private String successRedirectionURL;
        private String failureRedirectionURL;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomVerificationEmailTemplateRequest model) {
            super(model);
            this.templateName(model.templateName);
            this.fromEmailAddress(model.fromEmailAddress);
            this.templateSubject(model.templateSubject);
            this.templateContent(model.templateContent);
            this.successRedirectionURL(model.successRedirectionURL);
            this.failureRedirectionURL(model.failureRedirectionURL);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getFromEmailAddress() {
            return this.fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        public final String getTemplateSubject() {
            return this.templateSubject;
        }

        @Override
        public final Builder templateSubject(String templateSubject) {
            this.templateSubject = templateSubject;
            return this;
        }

        public final void setTemplateSubject(String templateSubject) {
            this.templateSubject = templateSubject;
        }

        public final String getTemplateContent() {
            return this.templateContent;
        }

        @Override
        public final Builder templateContent(String templateContent) {
            this.templateContent = templateContent;
            return this;
        }

        public final void setTemplateContent(String templateContent) {
            this.templateContent = templateContent;
        }

        public final String getSuccessRedirectionURL() {
            return this.successRedirectionURL;
        }

        @Override
        public final Builder successRedirectionURL(String successRedirectionURL) {
            this.successRedirectionURL = successRedirectionURL;
            return this;
        }

        public final void setSuccessRedirectionURL(String successRedirectionURL) {
            this.successRedirectionURL = successRedirectionURL;
        }

        public final String getFailureRedirectionURL() {
            return this.failureRedirectionURL;
        }

        @Override
        public final Builder failureRedirectionURL(String failureRedirectionURL) {
            this.failureRedirectionURL = failureRedirectionURL;
            return this;
        }

        public final void setFailureRedirectionURL(String failureRedirectionURL) {
            this.failureRedirectionURL = failureRedirectionURL;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomVerificationEmailTemplateRequest build() {
            return new UpdateCustomVerificationEmailTemplateRequest(this);
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    CopyableBuilder<Builder, UpdateCustomVerificationEmailTemplateRequest> {
        public Builder templateName(String var1);

        public Builder fromEmailAddress(String var1);

        public Builder templateSubject(String var1);

        public Builder templateContent(String var1);

        public Builder successRedirectionURL(String var1);

        public Builder failureRedirectionURL(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

