/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.CreateTemplateRequest;
import software.amazon.awssdk.services.ses.model.Template;

public class CreateTemplateRequestMarshaller
implements Marshaller<Request<CreateTemplateRequest>, CreateTemplateRequest> {
    public Request<CreateTemplateRequest> marshall(CreateTemplateRequest createTemplateRequest) {
        if (createTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createTemplateRequest, "SesClient");
        request.addParameter("Action", "CreateTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        Template template = createTemplateRequest.template();
        if (template != null) {
            if (template.templateName() != null) {
                request.addParameter("Template.TemplateName", StringConversion.fromString((String)template.templateName()));
            }
            if (template.subjectPart() != null) {
                request.addParameter("Template.SubjectPart", StringConversion.fromString((String)template.subjectPart()));
            }
            if (template.textPart() != null) {
                request.addParameter("Template.TextPart", StringConversion.fromString((String)template.textPart()));
            }
            if (template.htmlPart() != null) {
                request.addParameter("Template.HtmlPart", StringConversion.fromString((String)template.htmlPart()));
            }
        }
        return request;
    }
}

