/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest;

public class DescribeReceiptRuleRequestMarshaller
implements Marshaller<Request<DescribeReceiptRuleRequest>, DescribeReceiptRuleRequest> {
    public Request<DescribeReceiptRuleRequest> marshall(DescribeReceiptRuleRequest describeReceiptRuleRequest) {
        if (describeReceiptRuleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeReceiptRuleRequest, "SesClient");
        request.addParameter("Action", "DescribeReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReceiptRuleRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringConversion.fromString((String)describeReceiptRuleRequest.ruleSetName()));
        }
        if (describeReceiptRuleRequest.ruleName() != null) {
            request.addParameter("RuleName", StringConversion.fromString((String)describeReceiptRuleRequest.ruleName()));
        }
        return request;
    }
}

