/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;

public class GetIdentityVerificationAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityVerificationAttributesRequest>, GetIdentityVerificationAttributesRequest> {
    public Request<GetIdentityVerificationAttributesRequest> marshall(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) {
        if (getIdentityVerificationAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getIdentityVerificationAttributesRequest, "SesClient");
        request.addParameter("Action", "GetIdentityVerificationAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIdentityVerificationAttributesRequest.identities().isEmpty() && !(getIdentityVerificationAttributesRequest.identities() instanceof SdkAutoConstructList)) {
            request.addParameter("Identities", "");
        } else if (!getIdentityVerificationAttributesRequest.identities().isEmpty() && !(getIdentityVerificationAttributesRequest.identities() instanceof SdkAutoConstructList)) {
            List<String> identitiesList = getIdentityVerificationAttributesRequest.identities();
            int identitiesListIndex = 1;
            for (String identitiesListValue : identitiesList) {
                if (identitiesListValue != null) {
                    request.addParameter("Identities.member." + identitiesListIndex, StringConversion.fromString((String)identitiesListValue));
                }
                ++identitiesListIndex;
            }
        }
        return request;
    }
}

