/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.ListTemplatesRequest;

public class ListTemplatesRequestMarshaller
implements Marshaller<Request<ListTemplatesRequest>, ListTemplatesRequest> {
    public Request<ListTemplatesRequest> marshall(ListTemplatesRequest listTemplatesRequest) {
        if (listTemplatesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listTemplatesRequest, "SesClient");
        request.addParameter("Action", "ListTemplates");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listTemplatesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listTemplatesRequest.nextToken()));
        }
        if (listTemplatesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listTemplatesRequest.maxItems()));
        }
        return request;
    }
}

