/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.SNSDestination;

public class SNSDestinationUnmarshaller
implements Unmarshaller<SNSDestination, StaxUnmarshallerContext> {
    private static final SNSDestinationUnmarshaller INSTANCE = new SNSDestinationUnmarshaller();

    public SNSDestination unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SNSDestination.Builder snsDestination = SNSDestination.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("TopicARN", targetDepth)) continue;
                snsDestination.topicARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SNSDestination)snsDestination.build();
    }

    public static SNSDestinationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

