/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.BouncedRecipientInfo;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.MessageDsn;
import software.amazon.awssdk.services.ses.model.RecipientDsnFields;
import software.amazon.awssdk.services.ses.model.SendBounceRequest;

public class SendBounceRequestMarshaller
implements Marshaller<Request<SendBounceRequest>, SendBounceRequest> {
    public Request<SendBounceRequest> marshall(SendBounceRequest sendBounceRequest) {
        MessageDsn messageDsn;
        if (sendBounceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)sendBounceRequest, "SesClient");
        request.addParameter("Action", "SendBounce");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendBounceRequest.originalMessageId() != null) {
            request.addParameter("OriginalMessageId", StringConversion.fromString((String)sendBounceRequest.originalMessageId()));
        }
        if (sendBounceRequest.bounceSender() != null) {
            request.addParameter("BounceSender", StringConversion.fromString((String)sendBounceRequest.bounceSender()));
        }
        if (sendBounceRequest.explanation() != null) {
            request.addParameter("Explanation", StringConversion.fromString((String)sendBounceRequest.explanation()));
        }
        if ((messageDsn = sendBounceRequest.messageDsn()) != null) {
            if (messageDsn.reportingMta() != null) {
                request.addParameter("MessageDsn.ReportingMta", StringConversion.fromString((String)messageDsn.reportingMta()));
            }
            if (messageDsn.arrivalDate() != null) {
                request.addParameter("MessageDsn.ArrivalDate", StringConversion.fromInstant((Instant)messageDsn.arrivalDate()));
            }
            if (messageDsn.extensionFields().isEmpty() && !(messageDsn.extensionFields() instanceof SdkAutoConstructList)) {
                request.addParameter("MessageDsn.ExtensionFields", "");
            } else if (!messageDsn.extensionFields().isEmpty() && !(messageDsn.extensionFields() instanceof SdkAutoConstructList)) {
                List<ExtensionField> extensionFieldsList = messageDsn.extensionFields();
                int extensionFieldsListIndex = 1;
                for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                    if (extensionFieldsListValue.name() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringConversion.fromString((String)extensionFieldsListValue.name()));
                    }
                    if (extensionFieldsListValue.value() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringConversion.fromString((String)extensionFieldsListValue.value()));
                    }
                    ++extensionFieldsListIndex;
                }
            }
        }
        if (sendBounceRequest.bouncedRecipientInfoList().isEmpty() && !(sendBounceRequest.bouncedRecipientInfoList() instanceof SdkAutoConstructList)) {
            request.addParameter("BouncedRecipientInfoList", "");
        } else if (!sendBounceRequest.bouncedRecipientInfoList().isEmpty() && !(sendBounceRequest.bouncedRecipientInfoList() instanceof SdkAutoConstructList)) {
            List<BouncedRecipientInfo> bouncedRecipientInfoListList = sendBounceRequest.bouncedRecipientInfoList();
            int bouncedRecipientInfoListListIndex = 1;
            for (BouncedRecipientInfo bouncedRecipientInfoListListValue : bouncedRecipientInfoListList) {
                RecipientDsnFields recipientDsnFields;
                if (bouncedRecipientInfoListListValue.recipient() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".Recipient", StringConversion.fromString((String)bouncedRecipientInfoListListValue.recipient()));
                }
                if (bouncedRecipientInfoListListValue.recipientArn() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientArn", StringConversion.fromString((String)bouncedRecipientInfoListListValue.recipientArn()));
                }
                if (bouncedRecipientInfoListListValue.bounceTypeAsString() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".BounceType", StringConversion.fromString((String)bouncedRecipientInfoListListValue.bounceTypeAsString()));
                }
                if ((recipientDsnFields = bouncedRecipientInfoListListValue.recipientDsnFields()) != null) {
                    if (recipientDsnFields.finalRecipient() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.FinalRecipient", StringConversion.fromString((String)recipientDsnFields.finalRecipient()));
                    }
                    if (recipientDsnFields.actionAsString() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Action", StringConversion.fromString((String)recipientDsnFields.actionAsString()));
                    }
                    if (recipientDsnFields.remoteMta() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.RemoteMta", StringConversion.fromString((String)recipientDsnFields.remoteMta()));
                    }
                    if (recipientDsnFields.status() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Status", StringConversion.fromString((String)recipientDsnFields.status()));
                    }
                    if (recipientDsnFields.diagnosticCode() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.DiagnosticCode", StringConversion.fromString((String)recipientDsnFields.diagnosticCode()));
                    }
                    if (recipientDsnFields.lastAttemptDate() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.LastAttemptDate", StringConversion.fromInstant((Instant)recipientDsnFields.lastAttemptDate()));
                    }
                    if (recipientDsnFields.extensionFields().isEmpty() && !(recipientDsnFields.extensionFields() instanceof SdkAutoConstructList)) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields", "");
                    } else if (!recipientDsnFields.extensionFields().isEmpty() && !(recipientDsnFields.extensionFields() instanceof SdkAutoConstructList)) {
                        List<ExtensionField> extensionFieldsList = recipientDsnFields.extensionFields();
                        int extensionFieldsListIndex = 1;
                        for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                            if (extensionFieldsListValue.name() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringConversion.fromString((String)extensionFieldsListValue.name()));
                            }
                            if (extensionFieldsListValue.value() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringConversion.fromString((String)extensionFieldsListValue.value()));
                            }
                            ++extensionFieldsListIndex;
                        }
                    }
                }
                ++bouncedRecipientInfoListListIndex;
            }
        }
        if (sendBounceRequest.bounceSenderArn() != null) {
            request.addParameter("BounceSenderArn", StringConversion.fromString((String)sendBounceRequest.bounceSenderArn()));
        }
        return request;
    }
}

