/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest;

public class SetIdentityDkimEnabledRequestMarshaller
implements Marshaller<Request<SetIdentityDkimEnabledRequest>, SetIdentityDkimEnabledRequest> {
    public Request<SetIdentityDkimEnabledRequest> marshall(SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest) {
        if (setIdentityDkimEnabledRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setIdentityDkimEnabledRequest, "SesClient");
        request.addParameter("Action", "SetIdentityDkimEnabled");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setIdentityDkimEnabledRequest.identity() != null) {
            request.addParameter("Identity", StringConversion.fromString((String)setIdentityDkimEnabledRequest.identity()));
        }
        if (setIdentityDkimEnabledRequest.dkimEnabled() != null) {
            request.addParameter("DkimEnabled", StringConversion.fromBoolean((Boolean)setIdentityDkimEnabledRequest.dkimEnabled()));
        }
        return request;
    }
}

