/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest;

public class TestRenderTemplateRequestMarshaller
implements Marshaller<Request<TestRenderTemplateRequest>, TestRenderTemplateRequest> {
    public Request<TestRenderTemplateRequest> marshall(TestRenderTemplateRequest testRenderTemplateRequest) {
        if (testRenderTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)testRenderTemplateRequest, "SesClient");
        request.addParameter("Action", "TestRenderTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (testRenderTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)testRenderTemplateRequest.templateName()));
        }
        if (testRenderTemplateRequest.templateData() != null) {
            request.addParameter("TemplateData", StringConversion.fromString((String)testRenderTemplateRequest.templateData()));
        }
        return request;
    }
}

