/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest;

public class VerifyEmailAddressRequestMarshaller
implements Marshaller<Request<VerifyEmailAddressRequest>, VerifyEmailAddressRequest> {
    public Request<VerifyEmailAddressRequest> marshall(VerifyEmailAddressRequest verifyEmailAddressRequest) {
        if (verifyEmailAddressRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)verifyEmailAddressRequest, "SesClient");
        request.addParameter("Action", "VerifyEmailAddress");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (verifyEmailAddressRequest.emailAddress() != null) {
            request.addParameter("EmailAddress", StringConversion.fromString((String)verifyEmailAddressRequest.emailAddress()));
        }
        return request;
    }
}

