/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a configuration set event destination. A configuration set event destination, which
 * can be either Amazon CloudWatch or Amazon Kinesis Firehose, describes an AWS service in which Amazon SES publishes
 * the email sending events associated with a configuration set. For information about using configuration sets, see the
 * <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateConfigurationSetEventDestinationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateConfigurationSetEventDestinationRequest.Builder, CreateConfigurationSetEventDestinationRequest> {
    private final String configurationSetName;

    private final EventDestination eventDestination;

    private CreateConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        this.configurationSetName = builder.configurationSetName;
        this.eventDestination = builder.eventDestination;
    }

    /**
     * <p>
     * The name of the configuration set to which to apply the event destination.
     * </p>
     * 
     * @return The name of the configuration set to which to apply the event destination.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * An object that describes the AWS service to which Amazon SES will publish the email sending events associated
     * with the specified configuration set.
     * </p>
     * 
     * @return An object that describes the AWS service to which Amazon SES will publish the email sending events
     *         associated with the specified configuration set.
     */
    public EventDestination eventDestination() {
        return eventDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationSetName() == null) ? 0 : configurationSetName().hashCode());
        hashCode = 31 * hashCode + ((eventDestination() == null) ? 0 : eventDestination().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationSetEventDestinationRequest)) {
            return false;
        }
        CreateConfigurationSetEventDestinationRequest other = (CreateConfigurationSetEventDestinationRequest) obj;
        if (other.configurationSetName() == null ^ this.configurationSetName() == null) {
            return false;
        }
        if (other.configurationSetName() != null && !other.configurationSetName().equals(this.configurationSetName())) {
            return false;
        }
        if (other.eventDestination() == null ^ this.eventDestination() == null) {
            return false;
        }
        if (other.eventDestination() != null && !other.eventDestination().equals(this.eventDestination())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(configurationSetName()).append(",");
        }
        if (eventDestination() != null) {
            sb.append("EventDestination: ").append(eventDestination()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateConfigurationSetEventDestinationRequest> {
        /**
         * <p>
         * The name of the configuration set to which to apply the event destination.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to which to apply the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * An object that describes the AWS service to which Amazon SES will publish the email sending events associated
         * with the specified configuration set.
         * </p>
         * 
         * @param eventDestination
         *        An object that describes the AWS service to which Amazon SES will publish the email sending events
         *        associated with the specified configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestination(EventDestination eventDestination);
    }

    private static final class BuilderImpl implements Builder {
        private String configurationSetName;

        private EventDestination eventDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationSetEventDestinationRequest model) {
            setConfigurationSetName(model.configurationSetName);
            setEventDestination(model.eventDestination);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final EventDestination getEventDestination() {
            return eventDestination;
        }

        @Override
        public final Builder eventDestination(EventDestination eventDestination) {
            this.eventDestination = eventDestination;
            return this;
        }

        public final void setEventDestination(EventDestination eventDestination) {
            this.eventDestination = eventDestination;
        }

        @Override
        public CreateConfigurationSetEventDestinationRequest build() {
            return new CreateConfigurationSetEventDestinationRequest(this);
        }
    }
}
