/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the metadata and receipt rules for the receipt rule set that is currently active.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeActiveReceiptRuleSetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeActiveReceiptRuleSetResponse.Builder, DescribeActiveReceiptRuleSetResponse> {
    private final ReceiptRuleSetMetadata metadata;

    private final List<ReceiptRule> rules;

    private DescribeActiveReceiptRuleSetResponse(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and a
     * timestamp of when the rule set was created.
     * </p>
     * 
     * @return The metadata for the currently active receipt rule set. The metadata consists of the rule set name and a
     *         timestamp of when the rule set was created.
     */
    public ReceiptRuleSetMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The receipt rules that belong to the active rule set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The receipt rules that belong to the active rule set.
     */
    public List<ReceiptRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metadata() == null) ? 0 : metadata().hashCode());
        hashCode = 31 * hashCode + ((rules() == null) ? 0 : rules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActiveReceiptRuleSetResponse)) {
            return false;
        }
        DescribeActiveReceiptRuleSetResponse other = (DescribeActiveReceiptRuleSetResponse) obj;
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        if (other.rules() != null && !other.rules().equals(this.rules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (metadata() != null) {
            sb.append("Metadata: ").append(metadata()).append(",");
        }
        if (rules() != null) {
            sb.append("Rules: ").append(rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeActiveReceiptRuleSetResponse> {
        /**
         * <p>
         * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and a
         * timestamp of when the rule set was created.
         * </p>
         * 
         * @param metadata
         *        The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
         *        a timestamp of when the rule set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ReceiptRuleSetMetadata metadata);

        /**
         * <p>
         * The receipt rules that belong to the active rule set.
         * </p>
         * 
         * @param rules
         *        The receipt rules that belong to the active rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<ReceiptRule> rules);

        /**
         * <p>
         * The receipt rules that belong to the active rule set.
         * </p>
         * 
         * @param rules
         *        The receipt rules that belong to the active rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(ReceiptRule... rules);
    }

    private static final class BuilderImpl implements Builder {
        private ReceiptRuleSetMetadata metadata;

        private List<ReceiptRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActiveReceiptRuleSetResponse model) {
            setMetadata(model.metadata);
            setRules(model.rules);
        }

        public final ReceiptRuleSetMetadata getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(ReceiptRuleSetMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ReceiptRuleSetMetadata metadata) {
            this.metadata = metadata;
        }

        public final Collection<ReceiptRule> getRules() {
            return rules;
        }

        @Override
        public final Builder rules(Collection<ReceiptRule> rules) {
            this.rules = ReceiptRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ReceiptRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<ReceiptRule> rules) {
            this.rules = ReceiptRulesListCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(ReceiptRule... rules) {
            rules(Arrays.asList(rules));
        }

        @Override
        public DescribeActiveReceiptRuleSetResponse build() {
            return new DescribeActiveReceiptRuleSetResponse(this);
        }
    }
}
