/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the details of a configuration set. Configuration sets enable you to publish email sending events. For
 * information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigurationSetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeConfigurationSetResponse.Builder, DescribeConfigurationSetResponse> {
    private final ConfigurationSet configurationSet;

    private final List<EventDestination> eventDestinations;

    private DescribeConfigurationSetResponse(BuilderImpl builder) {
        this.configurationSet = builder.configurationSet;
        this.eventDestinations = builder.eventDestinations;
    }

    /**
     * <p>
     * The configuration set object associated with the specified configuration set.
     * </p>
     * 
     * @return The configuration set object associated with the specified configuration set.
     */
    public ConfigurationSet configurationSet() {
        return configurationSet;
    }

    /**
     * <p>
     * A list of event destinations associated with the configuration set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of event destinations associated with the configuration set.
     */
    public List<EventDestination> eventDestinations() {
        return eventDestinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationSet() == null) ? 0 : configurationSet().hashCode());
        hashCode = 31 * hashCode + ((eventDestinations() == null) ? 0 : eventDestinations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetResponse)) {
            return false;
        }
        DescribeConfigurationSetResponse other = (DescribeConfigurationSetResponse) obj;
        if (other.configurationSet() == null ^ this.configurationSet() == null) {
            return false;
        }
        if (other.configurationSet() != null && !other.configurationSet().equals(this.configurationSet())) {
            return false;
        }
        if (other.eventDestinations() == null ^ this.eventDestinations() == null) {
            return false;
        }
        if (other.eventDestinations() != null && !other.eventDestinations().equals(this.eventDestinations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configurationSet() != null) {
            sb.append("ConfigurationSet: ").append(configurationSet()).append(",");
        }
        if (eventDestinations() != null) {
            sb.append("EventDestinations: ").append(eventDestinations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigurationSetResponse> {
        /**
         * <p>
         * The configuration set object associated with the specified configuration set.
         * </p>
         * 
         * @param configurationSet
         *        The configuration set object associated with the specified configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSet(ConfigurationSet configurationSet);

        /**
         * <p>
         * A list of event destinations associated with the configuration set.
         * </p>
         * 
         * @param eventDestinations
         *        A list of event destinations associated with the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(Collection<EventDestination> eventDestinations);

        /**
         * <p>
         * A list of event destinations associated with the configuration set.
         * </p>
         * 
         * @param eventDestinations
         *        A list of event destinations associated with the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(EventDestination... eventDestinations);
    }

    private static final class BuilderImpl implements Builder {
        private ConfigurationSet configurationSet;

        private List<EventDestination> eventDestinations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetResponse model) {
            setConfigurationSet(model.configurationSet);
            setEventDestinations(model.eventDestinations);
        }

        public final ConfigurationSet getConfigurationSet() {
            return configurationSet;
        }

        @Override
        public final Builder configurationSet(ConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final void setConfigurationSet(ConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
        }

        public final Collection<EventDestination> getEventDestinations() {
            return eventDestinations;
        }

        @Override
        public final Builder eventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(EventDestination... eventDestinations) {
            eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        public final void setEventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copy(eventDestinations);
        }

        @SafeVarargs
        public final void setEventDestinations(EventDestination... eventDestinations) {
            eventDestinations(Arrays.asList(eventDestinations));
        }

        @Override
        public DescribeConfigurationSetResponse build() {
            return new DescribeConfigurationSetResponse(this);
        }
    }
}
