/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the notification attributes for a list of identities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityNotificationAttributesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetIdentityNotificationAttributesResponse.Builder, GetIdentityNotificationAttributesResponse> {
    private final Map<String, IdentityNotificationAttributes> notificationAttributes;

    private GetIdentityNotificationAttributesResponse(BuilderImpl builder) {
        this.notificationAttributes = builder.notificationAttributes;
    }

    /**
     * <p>
     * A map of Identity to IdentityNotificationAttributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of Identity to IdentityNotificationAttributes.
     */
    public Map<String, IdentityNotificationAttributes> notificationAttributes() {
        return notificationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((notificationAttributes() == null) ? 0 : notificationAttributes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityNotificationAttributesResponse)) {
            return false;
        }
        GetIdentityNotificationAttributesResponse other = (GetIdentityNotificationAttributesResponse) obj;
        if (other.notificationAttributes() == null ^ this.notificationAttributes() == null) {
            return false;
        }
        if (other.notificationAttributes() != null && !other.notificationAttributes().equals(this.notificationAttributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (notificationAttributes() != null) {
            sb.append("NotificationAttributes: ").append(notificationAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
        /**
         * <p>
         * A map of Identity to IdentityNotificationAttributes.
         * </p>
         * 
         * @param notificationAttributes
         *        A map of Identity to IdentityNotificationAttributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, IdentityNotificationAttributes> notificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityNotificationAttributesResponse model) {
            setNotificationAttributes(model.notificationAttributes);
        }

        public final Map<String, IdentityNotificationAttributes> getNotificationAttributes() {
            return notificationAttributes;
        }

        @Override
        public final Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copy(notificationAttributes);
            return this;
        }

        public final void setNotificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copy(notificationAttributes);
        }

        @Override
        public GetIdentityNotificationAttributesResponse build() {
            return new GetIdentityNotificationAttributesResponse(this);
        }
    }
}
