/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the custom MAIL FROM domain attributes of a verified identity (email address or domain).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IdentityMailFromDomainAttributes implements
        ToCopyableBuilder<IdentityMailFromDomainAttributes.Builder, IdentityMailFromDomainAttributes> {
    private final String mailFromDomain;

    private final String mailFromDomainStatus;

    private final String behaviorOnMXFailure;

    private IdentityMailFromDomainAttributes(BuilderImpl builder) {
        this.mailFromDomain = builder.mailFromDomain;
        this.mailFromDomainStatus = builder.mailFromDomainStatus;
        this.behaviorOnMXFailure = builder.behaviorOnMXFailure;
    }

    /**
     * <p>
     * The custom MAIL FROM domain that the identity is configured to use.
     * </p>
     * 
     * @return The custom MAIL FROM domain that the identity is configured to use.
     */
    public String mailFromDomain() {
        return mailFromDomain;
    }

    /**
     * <p>
     * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
     * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain when
     * the verified identity sends an email. All other states indicate that Amazon SES takes the action described by
     * <code>BehaviorOnMXFailure</code>.
     * </p>
     * 
     * @return The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL
     *         FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM
     *         domain when the verified identity sends an email. All other states indicate that Amazon SES takes the
     *         action described by <code>BehaviorOnMXFailure</code>.
     * @see CustomMailFromStatus
     */
    public String mailFromDomainStatus() {
        return mailFromDomainStatus;
    }

    /**
     * <p>
     * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an email. A
     * value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX record, it uses
     * amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of <code>RejectMessage</code> indicates
     * that if Amazon SES cannot read the required MX record, Amazon SES returns a
     * <code>MailFromDomainNotVerified</code> error and does not send the email.
     * </p>
     * <p>
     * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>, and
     * <code>TemporaryFailure</code>.
     * </p>
     * 
     * @return The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
     *         email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
     *         record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
     *         <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
     *         returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
     *         <p>
     *         The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
     *         <code>Failed</code>, and <code>TemporaryFailure</code>.
     * @see BehaviorOnMXFailure
     */
    public String behaviorOnMXFailure() {
        return behaviorOnMXFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mailFromDomain() == null) ? 0 : mailFromDomain().hashCode());
        hashCode = 31 * hashCode + ((mailFromDomainStatus() == null) ? 0 : mailFromDomainStatus().hashCode());
        hashCode = 31 * hashCode + ((behaviorOnMXFailure() == null) ? 0 : behaviorOnMXFailure().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityMailFromDomainAttributes)) {
            return false;
        }
        IdentityMailFromDomainAttributes other = (IdentityMailFromDomainAttributes) obj;
        if (other.mailFromDomain() == null ^ this.mailFromDomain() == null) {
            return false;
        }
        if (other.mailFromDomain() != null && !other.mailFromDomain().equals(this.mailFromDomain())) {
            return false;
        }
        if (other.mailFromDomainStatus() == null ^ this.mailFromDomainStatus() == null) {
            return false;
        }
        if (other.mailFromDomainStatus() != null && !other.mailFromDomainStatus().equals(this.mailFromDomainStatus())) {
            return false;
        }
        if (other.behaviorOnMXFailure() == null ^ this.behaviorOnMXFailure() == null) {
            return false;
        }
        if (other.behaviorOnMXFailure() != null && !other.behaviorOnMXFailure().equals(this.behaviorOnMXFailure())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (mailFromDomain() != null) {
            sb.append("MailFromDomain: ").append(mailFromDomain()).append(",");
        }
        if (mailFromDomainStatus() != null) {
            sb.append("MailFromDomainStatus: ").append(mailFromDomainStatus()).append(",");
        }
        if (behaviorOnMXFailure() != null) {
            sb.append("BehaviorOnMXFailure: ").append(behaviorOnMXFailure()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IdentityMailFromDomainAttributes> {
        /**
         * <p>
         * The custom MAIL FROM domain that the identity is configured to use.
         * </p>
         * 
         * @param mailFromDomain
         *        The custom MAIL FROM domain that the identity is configured to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomain(String mailFromDomain);

        /**
         * <p>
         * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
         * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain
         * when the verified identity sends an email. All other states indicate that Amazon SES takes the action
         * described by <code>BehaviorOnMXFailure</code>.
         * </p>
         * 
         * @param mailFromDomainStatus
         *        The state that indicates whether Amazon SES has successfully read the MX record required for custom
         *        MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom
         *        MAIL FROM domain when the verified identity sends an email. All other states indicate that Amazon SES
         *        takes the action described by <code>BehaviorOnMXFailure</code>.
         * @see CustomMailFromStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMailFromStatus
         */
        Builder mailFromDomainStatus(String mailFromDomainStatus);

        /**
         * <p>
         * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
         * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain
         * when the verified identity sends an email. All other states indicate that Amazon SES takes the action
         * described by <code>BehaviorOnMXFailure</code>.
         * </p>
         * 
         * @param mailFromDomainStatus
         *        The state that indicates whether Amazon SES has successfully read the MX record required for custom
         *        MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom
         *        MAIL FROM domain when the verified identity sends an email. All other states indicate that Amazon SES
         *        takes the action described by <code>BehaviorOnMXFailure</code>.
         * @see CustomMailFromStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMailFromStatus
         */
        Builder mailFromDomainStatus(CustomMailFromStatus mailFromDomainStatus);

        /**
         * <p>
         * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
         * email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
         * record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         * <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         * returns a <code>MailFromDomainNotVerified</code> error and does not send the email.
         * </p>
         * <p>
         * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>,
         * and <code>TemporaryFailure</code>.
         * </p>
         * 
         * @param behaviorOnMXFailure
         *        The action that Amazon SES takes if it cannot successfully read the required MX record when you send
         *        an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the
         *        required MX record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         *        <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         *        returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
         *        <p>
         *        The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
         *        <code>Failed</code>, and <code>TemporaryFailure</code>.
         * @see BehaviorOnMXFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMXFailure
         */
        Builder behaviorOnMXFailure(String behaviorOnMXFailure);

        /**
         * <p>
         * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
         * email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
         * record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         * <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         * returns a <code>MailFromDomainNotVerified</code> error and does not send the email.
         * </p>
         * <p>
         * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>,
         * and <code>TemporaryFailure</code>.
         * </p>
         * 
         * @param behaviorOnMXFailure
         *        The action that Amazon SES takes if it cannot successfully read the required MX record when you send
         *        an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the
         *        required MX record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         *        <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         *        returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
         *        <p>
         *        The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
         *        <code>Failed</code>, and <code>TemporaryFailure</code>.
         * @see BehaviorOnMXFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMXFailure
         */
        Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure);
    }

    private static final class BuilderImpl implements Builder {
        private String mailFromDomain;

        private String mailFromDomainStatus;

        private String behaviorOnMXFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityMailFromDomainAttributes model) {
            setMailFromDomain(model.mailFromDomain);
            setMailFromDomainStatus(model.mailFromDomainStatus);
            setBehaviorOnMXFailure(model.behaviorOnMXFailure);
        }

        public final String getMailFromDomain() {
            return mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        public final String getMailFromDomainStatus() {
            return mailFromDomainStatus;
        }

        @Override
        public final Builder mailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
            return this;
        }

        @Override
        public final Builder mailFromDomainStatus(CustomMailFromStatus mailFromDomainStatus) {
            this.mailFromDomainStatus(mailFromDomainStatus.toString());
            return this;
        }

        public final void setMailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
        }

        public final void setMailFromDomainStatus(CustomMailFromStatus mailFromDomainStatus) {
            this.mailFromDomainStatus(mailFromDomainStatus.toString());
        }

        public final String getBehaviorOnMXFailure() {
            return behaviorOnMXFailure;
        }

        @Override
        public final Builder behaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure) {
            this.behaviorOnMXFailure(behaviorOnMXFailure.toString());
            return this;
        }

        public final void setBehaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
        }

        public final void setBehaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure) {
            this.behaviorOnMXFailure(behaviorOnMXFailure.toString());
        }

        @Override
        public IdentityMailFromDomainAttributes build() {
            return new IdentityMailFromDomainAttributes(this);
        }
    }
}
