/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to reorder the receipt rules within a receipt rule set. You use receipt rule sets to receive
 * email with Amazon SES. For more information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReorderReceiptRuleSetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ReorderReceiptRuleSetRequest.Builder, ReorderReceiptRuleSetRequest> {
    private final String ruleSetName;

    private final List<String> ruleNames;

    private ReorderReceiptRuleSetRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.ruleNames = builder.ruleNames;
    }

    /**
     * <p>
     * The name of the receipt rule set to reorder.
     * </p>
     * 
     * @return The name of the receipt rule set to reorder.
     */
    public String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * A list of the specified receipt rule set's receipt rules in the order that you want to put them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the specified receipt rule set's receipt rules in the order that you want to put them.
     */
    public List<String> ruleNames() {
        return ruleNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleSetName() == null) ? 0 : ruleSetName().hashCode());
        hashCode = 31 * hashCode + ((ruleNames() == null) ? 0 : ruleNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReorderReceiptRuleSetRequest)) {
            return false;
        }
        ReorderReceiptRuleSetRequest other = (ReorderReceiptRuleSetRequest) obj;
        if (other.ruleSetName() == null ^ this.ruleSetName() == null) {
            return false;
        }
        if (other.ruleSetName() != null && !other.ruleSetName().equals(this.ruleSetName())) {
            return false;
        }
        if (other.ruleNames() == null ^ this.ruleNames() == null) {
            return false;
        }
        if (other.ruleNames() != null && !other.ruleNames().equals(this.ruleNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ruleSetName() != null) {
            sb.append("RuleSetName: ").append(ruleSetName()).append(",");
        }
        if (ruleNames() != null) {
            sb.append("RuleNames: ").append(ruleNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReorderReceiptRuleSetRequest> {
        /**
         * <p>
         * The name of the receipt rule set to reorder.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the receipt rule set to reorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * A list of the specified receipt rule set's receipt rules in the order that you want to put them.
         * </p>
         * 
         * @param ruleNames
         *        A list of the specified receipt rule set's receipt rules in the order that you want to put them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(Collection<String> ruleNames);

        /**
         * <p>
         * A list of the specified receipt rule set's receipt rules in the order that you want to put them.
         * </p>
         * 
         * @param ruleNames
         *        A list of the specified receipt rule set's receipt rules in the order that you want to put them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(String... ruleNames);
    }

    private static final class BuilderImpl implements Builder {
        private String ruleSetName;

        private List<String> ruleNames;

        private BuilderImpl() {
        }

        private BuilderImpl(ReorderReceiptRuleSetRequest model) {
            setRuleSetName(model.ruleSetName);
            setRuleNames(model.ruleNames);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final Collection<String> getRuleNames() {
            return ruleNames;
        }

        @Override
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = ReceiptRuleNamesListCopier.copy(ruleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleNames(String... ruleNames) {
            ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = ReceiptRuleNamesListCopier.copy(ruleNames);
        }

        @SafeVarargs
        public final void setRuleNames(String... ruleNames) {
            ruleNames(Arrays.asList(ruleNames));
        }

        @Override
        public ReorderReceiptRuleSetRequest build() {
            return new ReorderReceiptRuleSetRequest(this);
        }
    }
}
