/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * Destination StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DestinationUnmarshaller implements Unmarshaller<Destination, StaxUnmarshallerContext> {

    public Destination unmarshall(StaxUnmarshallerContext context) throws Exception {
        Destination.Builder destination = Destination.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> toAddresses = null;
        java.util.List<String> ccAddresses = null;
        java.util.List<String> bccAddresses = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                destination.toAddresses(toAddresses);
                destination.ccAddresses(ccAddresses);
                destination.bccAddresses(bccAddresses);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("ToAddresses", targetDepth)) {
                    toAddresses = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("ToAddresses/member", targetDepth)) {
                    toAddresses.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CcAddresses", targetDepth)) {
                    ccAddresses = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("CcAddresses/member", targetDepth)) {
                    ccAddresses.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("BccAddresses", targetDepth)) {
                    bccAddresses = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("BccAddresses/member", targetDepth)) {
                    bccAddresses.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    destination.toAddresses(toAddresses);
                    destination.ccAddresses(ccAddresses);
                    destination.bccAddresses(bccAddresses);
                    break;
                }
            }
        }
        return destination.build();
    }

    private static DestinationUnmarshaller INSTANCE;

    public static DestinationUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DestinationUnmarshaller();
        return INSTANCE;
    }
}
