/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ReceiptRule StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReceiptRuleUnmarshaller implements Unmarshaller<ReceiptRule, StaxUnmarshallerContext> {

    public ReceiptRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReceiptRule.Builder receiptRule = ReceiptRule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> recipients = null;
        java.util.List<ReceiptAction> actions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                receiptRule.recipients(recipients);
                receiptRule.actions(actions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Name", targetDepth)) {
                    receiptRule.name(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Enabled", targetDepth)) {
                    receiptRule.enabled(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TlsPolicy", targetDepth)) {
                    receiptRule.tlsPolicy(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Recipients", targetDepth)) {
                    recipients = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("Recipients/member", targetDepth)) {
                    recipients.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Actions", targetDepth)) {
                    actions = new ArrayList<ReceiptAction>();
                    continue;
                }

                if (context.testExpression("Actions/member", targetDepth)) {
                    actions.add(ReceiptActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ScanEnabled", targetDepth)) {
                    receiptRule.scanEnabled(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    receiptRule.recipients(recipients);
                    receiptRule.actions(actions);
                    break;
                }
            }
        }
        return receiptRule.build();
    }

    private static ReceiptRuleUnmarshaller INSTANCE;

    public static ReceiptRuleUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ReceiptRuleUnmarshaller();
        return INSTANCE;
    }
}
