/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * SendDataPoint StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendDataPointUnmarshaller implements Unmarshaller<SendDataPoint, StaxUnmarshallerContext> {

    public SendDataPoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        SendDataPoint.Builder sendDataPoint = SendDataPoint.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Timestamp", targetDepth)) {
                    sendDataPoint.timestamp(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DeliveryAttempts", targetDepth)) {
                    sendDataPoint.deliveryAttempts(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Bounces", targetDepth)) {
                    sendDataPoint.bounces(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Complaints", targetDepth)) {
                    sendDataPoint.complaints(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Rejects", targetDepth)) {
                    sendDataPoint.rejects(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return sendDataPoint.build();
    }

    private static SendDataPointUnmarshaller INSTANCE;

    public static SendDataPointUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new SendDataPointUnmarshaller();
        return INSTANCE;
    }
}
