/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteConfigurationSetEventDestinationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteConfigurationSetEventDestinationRequest> {
    private final String configurationSetName;
    private final String eventDestinationName;

    private DeleteConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinationName = builder.eventDestinationName;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public String eventDestinationName() {
        return this.eventDestinationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configurationSetName() == null ? 0 : this.configurationSetName().hashCode());
        hashCode = 31 * hashCode + (this.eventDestinationName() == null ? 0 : this.eventDestinationName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigurationSetEventDestinationRequest)) {
            return false;
        }
        DeleteConfigurationSetEventDestinationRequest other = (DeleteConfigurationSetEventDestinationRequest)((Object)obj);
        if (other.configurationSetName() == null ^ this.configurationSetName() == null) {
            return false;
        }
        if (other.configurationSetName() != null && !other.configurationSetName().equals(this.configurationSetName())) {
            return false;
        }
        if (other.eventDestinationName() == null ^ this.eventDestinationName() == null) {
            return false;
        }
        return other.eventDestinationName() == null || other.eventDestinationName().equals(this.eventDestinationName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(this.configurationSetName()).append(",");
        }
        if (this.eventDestinationName() != null) {
            sb.append("EventDestinationName: ").append(this.eventDestinationName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String configurationSetName;
        private String eventDestinationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigurationSetEventDestinationRequest model) {
            this.setConfigurationSetName(model.configurationSetName);
            this.setEventDestinationName(model.eventDestinationName);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final String getEventDestinationName() {
            return this.eventDestinationName;
        }

        @Override
        public final Builder eventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
            return this;
        }

        public final void setEventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
        }

        public DeleteConfigurationSetEventDestinationRequest build() {
            return new DeleteConfigurationSetEventDestinationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteConfigurationSetEventDestinationRequest> {
        public Builder configurationSetName(String var1);

        public Builder eventDestinationName(String var1);
    }
}

