/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.CloudWatchDestination;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration;
import software.amazon.awssdk.services.ses.transform.CloudWatchDimensionConfigurationUnmarshaller;

public class CloudWatchDestinationUnmarshaller
implements Unmarshaller<CloudWatchDestination, StaxUnmarshallerContext> {
    private static CloudWatchDestinationUnmarshaller INSTANCE;

    public CloudWatchDestination unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudWatchDestination.Builder cloudWatchDestination;
        block5: {
            cloudWatchDestination = CloudWatchDestination.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<CloudWatchDimensionConfiguration> dimensionConfigurations = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    cloudWatchDestination.dimensionConfigurations(dimensionConfigurations);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("DimensionConfigurations", targetDepth)) {
                        dimensionConfigurations = new ArrayList<CloudWatchDimensionConfiguration>();
                        continue;
                    }
                    if (!context.testExpression("DimensionConfigurations/member", targetDepth)) continue;
                    dimensionConfigurations.add(CloudWatchDimensionConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            cloudWatchDestination.dimensionConfigurations(dimensionConfigurations);
        }
        return (CloudWatchDestination)cloudWatchDestination.build();
    }

    public static CloudWatchDestinationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CloudWatchDestinationUnmarshaller();
        }
        return INSTANCE;
    }
}

