/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.DeleteIdentityRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteIdentityRequestMarshaller
implements Marshaller<Request<DeleteIdentityRequest>, DeleteIdentityRequest> {
    public Request<DeleteIdentityRequest> marshall(DeleteIdentityRequest deleteIdentityRequest) {
        if (deleteIdentityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteIdentityRequest, "SESClient");
        request.addParameter("Action", "DeleteIdentity");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteIdentityRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)deleteIdentityRequest.identity()));
        }
        return request;
    }
}

