/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.SNSAction;

public class SNSActionUnmarshaller
implements Unmarshaller<SNSAction, StaxUnmarshallerContext> {
    private static SNSActionUnmarshaller INSTANCE;

    public SNSAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SNSAction.Builder snsAction = SNSAction.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TopicArn", targetDepth)) {
                    snsAction.topicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Encoding", targetDepth)) continue;
                snsAction.encoding(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SNSAction)snsAction.build();
    }

    public static SNSActionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SNSActionUnmarshaller();
        }
        return INSTANCE;
    }
}

