/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action adds a header to the received email.
 * </p>
 * <p>
 * For information about adding a header using a receipt rule, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-add-header.html">Amazon SES
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddHeaderAction implements ToCopyableBuilder<AddHeaderAction.Builder, AddHeaderAction> {
    private final String headerName;

    private final String headerValue;

    private AddHeaderAction(BuilderImpl builder) {
        this.headerName = builder.headerName;
        this.headerValue = builder.headerValue;
    }

    /**
     * <p>
     * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z,
     * A-Z, 0-9) characters and dashes only.
     * </p>
     * 
     * @return The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of
     *         alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
     */
    public String headerName() {
        return headerName;
    }

    /**
     * <p>
     * Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
     * </p>
     * 
     * @return Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
     */
    public String headerValue() {
        return headerValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((headerName() == null) ? 0 : headerName().hashCode());
        hashCode = 31 * hashCode + ((headerValue() == null) ? 0 : headerValue().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddHeaderAction)) {
            return false;
        }
        AddHeaderAction other = (AddHeaderAction) obj;
        if (other.headerName() == null ^ this.headerName() == null) {
            return false;
        }
        if (other.headerName() != null && !other.headerName().equals(this.headerName())) {
            return false;
        }
        if (other.headerValue() == null ^ this.headerValue() == null) {
            return false;
        }
        if (other.headerValue() != null && !other.headerValue().equals(this.headerValue())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (headerName() != null) {
            sb.append("HeaderName: ").append(headerName()).append(",");
        }
        if (headerValue() != null) {
            sb.append("HeaderValue: ").append(headerValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AddHeaderAction> {
        /**
         * <p>
         * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric
         * (a-z, A-Z, 0-9) characters and dashes only.
         * </p>
         * 
         * @param headerName
         *        The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of
         *        alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerName(String headerName);

        /**
         * <p>
         * Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
         * </p>
         * 
         * @param headerValue
         *        Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerValue(String headerValue);
    }

    private static final class BuilderImpl implements Builder {
        private String headerName;

        private String headerValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AddHeaderAction model) {
            setHeaderName(model.headerName);
            setHeaderValue(model.headerValue);
        }

        public final String getHeaderName() {
            return headerName;
        }

        @Override
        public final Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public final void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public final String getHeaderValue() {
            return headerValue;
        }

        @Override
        public final Builder headerValue(String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public final void setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
        }

        @Override
        public AddHeaderAction build() {
            return new AddHeaderAction(this);
        }
    }
}
