/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Recipient-related information to include in the Delivery Status Notification (DSN) when an email that Amazon SES
 * receives on your behalf bounces.
 * </p>
 * <p>
 * For information about receiving email through Amazon SES, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BouncedRecipientInfo implements ToCopyableBuilder<BouncedRecipientInfo.Builder, BouncedRecipientInfo> {
    private final String recipient;

    private final String recipientArn;

    private final String bounceType;

    private final RecipientDsnFields recipientDsnFields;

    private BouncedRecipientInfo(BuilderImpl builder) {
        this.recipient = builder.recipient;
        this.recipientArn = builder.recipientArn;
        this.bounceType = builder.bounceType;
        this.recipientDsnFields = builder.recipientDsnFields;
    }

    /**
     * <p>
     * The email address of the recipient of the bounced email.
     * </p>
     * 
     * @return The email address of the recipient of the bounced email.
     */
    public String recipient() {
        return recipient;
    }

    /**
     * <p>
     * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the
     * sending authorization policy that permits you to receive email for the recipient of the bounced email. For more
     * information about sending authorization, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * 
     * @return This parameter is used only for sending authorization. It is the ARN of the identity that is associated
     *         with the sending authorization policy that permits you to receive email for the recipient of the bounced
     *         email. For more information about sending authorization, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
     *         Developer Guide</a>.
     */
    public String recipientArn() {
        return recipientArn;
    }

    /**
     * <p>
     * The reason for the bounce. You must provide either this parameter or <code>RecipientDsnFields</code>.
     * </p>
     * 
     * @return The reason for the bounce. You must provide either this parameter or <code>RecipientDsnFields</code>.
     * @see BounceType
     */
    public String bounceType() {
        return bounceType;
    }

    /**
     * <p>
     * Recipient-related DSN fields, most of which would normally be filled in automatically when provided with a
     * <code>BounceType</code>. You must provide either this parameter or <code>BounceType</code>.
     * </p>
     * 
     * @return Recipient-related DSN fields, most of which would normally be filled in automatically when provided with
     *         a <code>BounceType</code>. You must provide either this parameter or <code>BounceType</code>.
     */
    public RecipientDsnFields recipientDsnFields() {
        return recipientDsnFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((recipient() == null) ? 0 : recipient().hashCode());
        hashCode = 31 * hashCode + ((recipientArn() == null) ? 0 : recipientArn().hashCode());
        hashCode = 31 * hashCode + ((bounceType() == null) ? 0 : bounceType().hashCode());
        hashCode = 31 * hashCode + ((recipientDsnFields() == null) ? 0 : recipientDsnFields().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BouncedRecipientInfo)) {
            return false;
        }
        BouncedRecipientInfo other = (BouncedRecipientInfo) obj;
        if (other.recipient() == null ^ this.recipient() == null) {
            return false;
        }
        if (other.recipient() != null && !other.recipient().equals(this.recipient())) {
            return false;
        }
        if (other.recipientArn() == null ^ this.recipientArn() == null) {
            return false;
        }
        if (other.recipientArn() != null && !other.recipientArn().equals(this.recipientArn())) {
            return false;
        }
        if (other.bounceType() == null ^ this.bounceType() == null) {
            return false;
        }
        if (other.bounceType() != null && !other.bounceType().equals(this.bounceType())) {
            return false;
        }
        if (other.recipientDsnFields() == null ^ this.recipientDsnFields() == null) {
            return false;
        }
        if (other.recipientDsnFields() != null && !other.recipientDsnFields().equals(this.recipientDsnFields())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (recipient() != null) {
            sb.append("Recipient: ").append(recipient()).append(",");
        }
        if (recipientArn() != null) {
            sb.append("RecipientArn: ").append(recipientArn()).append(",");
        }
        if (bounceType() != null) {
            sb.append("BounceType: ").append(bounceType()).append(",");
        }
        if (recipientDsnFields() != null) {
            sb.append("RecipientDsnFields: ").append(recipientDsnFields()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BouncedRecipientInfo> {
        /**
         * <p>
         * The email address of the recipient of the bounced email.
         * </p>
         * 
         * @param recipient
         *        The email address of the recipient of the bounced email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipient(String recipient);

        /**
         * <p>
         * This parameter is used only for sending authorization. It is the ARN of the identity that is associated with
         * the sending authorization policy that permits you to receive email for the recipient of the bounced email.
         * For more information about sending authorization, see the <a
         * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
         * Guide</a>.
         * </p>
         * 
         * @param recipientArn
         *        This parameter is used only for sending authorization. It is the ARN of the identity that is
         *        associated with the sending authorization policy that permits you to receive email for the recipient
         *        of the bounced email. For more information about sending authorization, see the <a
         *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES
         *        Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipientArn(String recipientArn);

        /**
         * <p>
         * The reason for the bounce. You must provide either this parameter or <code>RecipientDsnFields</code>.
         * </p>
         * 
         * @param bounceType
         *        The reason for the bounce. You must provide either this parameter or <code>RecipientDsnFields</code>.
         * @see BounceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BounceType
         */
        Builder bounceType(String bounceType);

        /**
         * <p>
         * The reason for the bounce. You must provide either this parameter or <code>RecipientDsnFields</code>.
         * </p>
         * 
         * @param bounceType
         *        The reason for the bounce. You must provide either this parameter or <code>RecipientDsnFields</code>.
         * @see BounceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BounceType
         */
        Builder bounceType(BounceType bounceType);

        /**
         * <p>
         * Recipient-related DSN fields, most of which would normally be filled in automatically when provided with a
         * <code>BounceType</code>. You must provide either this parameter or <code>BounceType</code>.
         * </p>
         * 
         * @param recipientDsnFields
         *        Recipient-related DSN fields, most of which would normally be filled in automatically when provided
         *        with a <code>BounceType</code>. You must provide either this parameter or <code>BounceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipientDsnFields(RecipientDsnFields recipientDsnFields);
    }

    private static final class BuilderImpl implements Builder {
        private String recipient;

        private String recipientArn;

        private String bounceType;

        private RecipientDsnFields recipientDsnFields;

        private BuilderImpl() {
        }

        private BuilderImpl(BouncedRecipientInfo model) {
            setRecipient(model.recipient);
            setRecipientArn(model.recipientArn);
            setBounceType(model.bounceType);
            setRecipientDsnFields(model.recipientDsnFields);
        }

        public final String getRecipient() {
            return recipient;
        }

        @Override
        public final Builder recipient(String recipient) {
            this.recipient = recipient;
            return this;
        }

        public final void setRecipient(String recipient) {
            this.recipient = recipient;
        }

        public final String getRecipientArn() {
            return recipientArn;
        }

        @Override
        public final Builder recipientArn(String recipientArn) {
            this.recipientArn = recipientArn;
            return this;
        }

        public final void setRecipientArn(String recipientArn) {
            this.recipientArn = recipientArn;
        }

        public final String getBounceType() {
            return bounceType;
        }

        @Override
        public final Builder bounceType(String bounceType) {
            this.bounceType = bounceType;
            return this;
        }

        @Override
        public final Builder bounceType(BounceType bounceType) {
            this.bounceType(bounceType.toString());
            return this;
        }

        public final void setBounceType(String bounceType) {
            this.bounceType = bounceType;
        }

        public final RecipientDsnFields getRecipientDsnFields() {
            return recipientDsnFields;
        }

        @Override
        public final Builder recipientDsnFields(RecipientDsnFields recipientDsnFields) {
            this.recipientDsnFields = recipientDsnFields;
            return this;
        }

        public final void setRecipientDsnFields(RecipientDsnFields recipientDsnFields) {
            this.recipientDsnFields = recipientDsnFields;
        }

        @Override
        public BouncedRecipientInfo build() {
            return new BouncedRecipientInfo(this);
        }
    }
}
