/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to return the requested sending authorization policies for an identity. Sending authorization is
 * an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityPoliciesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetIdentityPoliciesRequest.Builder, GetIdentityPoliciesRequest> {
    private final String identity;

    private final List<String> policyNames;

    private GetIdentityPoliciesRequest(BuilderImpl builder) {
        this.identity = builder.identity;
        this.policyNames = builder.policyNames;
    }

    /**
     * <p>
     * The identity for which the policies will be retrieved. You can specify an identity by using its name or by using
     * its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
     * <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
     * </p>
     * <p>
     * To successfully call this API, you must own the identity.
     * </p>
     * 
     * @return The identity for which the policies will be retrieved. You can specify an identity by using its name or
     *         by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
     *         <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
     *         <p>
     *         To successfully call this API, you must own the identity.
     */
    public String identity() {
        return identity;
    }

    /**
     * <p>
     * A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If you do
     * not know the names of the policies that are attached to the identity, you can use
     * <code>ListIdentityPolicies</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If
     *         you do not know the names of the policies that are attached to the identity, you can use
     *         <code>ListIdentityPolicies</code>.
     */
    public List<String> policyNames() {
        return policyNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identity() == null) ? 0 : identity().hashCode());
        hashCode = 31 * hashCode + ((policyNames() == null) ? 0 : policyNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoliciesRequest)) {
            return false;
        }
        GetIdentityPoliciesRequest other = (GetIdentityPoliciesRequest) obj;
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        if (other.policyNames() == null ^ this.policyNames() == null) {
            return false;
        }
        if (other.policyNames() != null && !other.policyNames().equals(this.policyNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identity() != null) {
            sb.append("Identity: ").append(identity()).append(",");
        }
        if (policyNames() != null) {
            sb.append("PolicyNames: ").append(policyNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetIdentityPoliciesRequest> {
        /**
         * <p>
         * The identity for which the policies will be retrieved. You can specify an identity by using its name or by
         * using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
         * <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
         * </p>
         * <p>
         * To successfully call this API, you must own the identity.
         * </p>
         * 
         * @param identity
         *        The identity for which the policies will be retrieved. You can specify an identity by using its name
         *        or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
         *        <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
         *        <p>
         *        To successfully call this API, you must own the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If you
         * do not know the names of the policies that are attached to the identity, you can use
         * <code>ListIdentityPolicies</code>.
         * </p>
         * 
         * @param policyNames
         *        A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time.
         *        If you do not know the names of the policies that are attached to the identity, you can use
         *        <code>ListIdentityPolicies</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(Collection<String> policyNames);

        /**
         * <p>
         * A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time. If you
         * do not know the names of the policies that are attached to the identity, you can use
         * <code>ListIdentityPolicies</code>.
         * </p>
         * 
         * @param policyNames
         *        A list of the names of policies to be retrieved. You can retrieve a maximum of 20 policies at a time.
         *        If you do not know the names of the policies that are attached to the identity, you can use
         *        <code>ListIdentityPolicies</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(String... policyNames);
    }

    private static final class BuilderImpl implements Builder {
        private String identity;

        private List<String> policyNames;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoliciesRequest model) {
            setIdentity(model.identity);
            setPolicyNames(model.policyNames);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final Collection<String> getPolicyNames() {
            return policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String... policyNames) {
            policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNameListCopier.copy(policyNames);
        }

        @Override
        public GetIdentityPoliciesRequest build() {
            return new GetIdentityPoliciesRequest(this);
        }
    }
}
