/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of IP address filters that exist under your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListReceiptFiltersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListReceiptFiltersResponse.Builder, ListReceiptFiltersResponse> {
    private final List<ReceiptFilter> filters;

    private ListReceiptFiltersResponse(BuilderImpl builder) {
        this.filters = builder.filters;
    }

    /**
     * <p>
     * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether to
     * allow or block mail from it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of IP address filter data structures, which each consist of a name, an IP address range, and
     *         whether to allow or block mail from it.
     */
    public List<ReceiptFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceiptFiltersResponse)) {
            return false;
        }
        ListReceiptFiltersResponse other = (ListReceiptFiltersResponse) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListReceiptFiltersResponse> {
        /**
         * <p>
         * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether
         * to allow or block mail from it.
         * </p>
         * 
         * @param filters
         *        A list of IP address filter data structures, which each consist of a name, an IP address range, and
         *        whether to allow or block mail from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ReceiptFilter> filters);

        /**
         * <p>
         * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether
         * to allow or block mail from it.
         * </p>
         * 
         * @param filters
         *        A list of IP address filter data structures, which each consist of a name, an IP address range, and
         *        whether to allow or block mail from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ReceiptFilter... filters);
    }

    private static final class BuilderImpl implements Builder {
        private List<ReceiptFilter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceiptFiltersResponse model) {
            setFilters(model.filters);
        }

        public final Collection<ReceiptFilter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<ReceiptFilter> filters) {
            this.filters = ReceiptFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ReceiptFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<ReceiptFilter> filters) {
            this.filters = ReceiptFilterListCopier.copy(filters);
        }

        @Override
        public ListReceiptFiltersResponse build() {
            return new ListReceiptFiltersResponse(this);
        }
    }
}
