/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A receipt IP address filter enables you to specify whether to accept or reject mail originating from an IP address or
 * range of IP addresses.
 * </p>
 * <p>
 * For information about setting up IP address filters, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReceiptIpFilter implements ToCopyableBuilder<ReceiptIpFilter.Builder, ReceiptIpFilter> {
    private final String policy;

    private final String cidr;

    private ReceiptIpFilter(BuilderImpl builder) {
        this.policy = builder.policy;
        this.cidr = builder.cidr;
    }

    /**
     * <p>
     * Indicates whether to block or allow incoming mail from the specified IP addresses.
     * </p>
     * 
     * @return Indicates whether to block or allow incoming mail from the specified IP addresses.
     * @see ReceiptFilterPolicy
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * A single IP address or a range of IP addresses that you want to block or allow, specified in Classless
     * Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of a range of
     * IP addresses is 10.0.0.1/24. For more information about CIDR notation, see <a
     * href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.
     * </p>
     * 
     * @return A single IP address or a range of IP addresses that you want to block or allow, specified in Classless
     *         Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of a
     *         range of IP addresses is 10.0.0.1/24. For more information about CIDR notation, see <a
     *         href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.
     */
    public String cidr() {
        return cidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policy() == null) ? 0 : policy().hashCode());
        hashCode = 31 * hashCode + ((cidr() == null) ? 0 : cidr().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptIpFilter)) {
            return false;
        }
        ReceiptIpFilter other = (ReceiptIpFilter) obj;
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        if (other.policy() != null && !other.policy().equals(this.policy())) {
            return false;
        }
        if (other.cidr() == null ^ this.cidr() == null) {
            return false;
        }
        if (other.cidr() != null && !other.cidr().equals(this.cidr())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (policy() != null) {
            sb.append("Policy: ").append(policy()).append(",");
        }
        if (cidr() != null) {
            sb.append("Cidr: ").append(cidr()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReceiptIpFilter> {
        /**
         * <p>
         * Indicates whether to block or allow incoming mail from the specified IP addresses.
         * </p>
         * 
         * @param policy
         *        Indicates whether to block or allow incoming mail from the specified IP addresses.
         * @see ReceiptFilterPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReceiptFilterPolicy
         */
        Builder policy(String policy);

        /**
         * <p>
         * Indicates whether to block or allow incoming mail from the specified IP addresses.
         * </p>
         * 
         * @param policy
         *        Indicates whether to block or allow incoming mail from the specified IP addresses.
         * @see ReceiptFilterPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReceiptFilterPolicy
         */
        Builder policy(ReceiptFilterPolicy policy);

        /**
         * <p>
         * A single IP address or a range of IP addresses that you want to block or allow, specified in Classless
         * Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of a range
         * of IP addresses is 10.0.0.1/24. For more information about CIDR notation, see <a
         * href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.
         * </p>
         * 
         * @param cidr
         *        A single IP address or a range of IP addresses that you want to block or allow, specified in Classless
         *        Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of
         *        a range of IP addresses is 10.0.0.1/24. For more information about CIDR notation, see <a
         *        href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);
    }

    private static final class BuilderImpl implements Builder {
        private String policy;

        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptIpFilter model) {
            setPolicy(model.policy);
            setCidr(model.cidr);
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public final Builder policy(ReceiptFilterPolicy policy) {
            this.policy(policy.toString());
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getCidr() {
            return cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public ReceiptIpFilter build() {
            return new ReceiptIpFilter(this);
        }
    }
}
