/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to begin Amazon SES domain verification and to generate the TXT records that you must publish to
 * the DNS server of your domain to complete the verification. For information about domain verification, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VerifyDomainIdentityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<VerifyDomainIdentityRequest.Builder, VerifyDomainIdentityRequest> {
    private final String domain;

    private VerifyDomainIdentityRequest(BuilderImpl builder) {
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The domain to be verified.
     * </p>
     * 
     * @return The domain to be verified.
     */
    public String domain() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDomainIdentityRequest)) {
            return false;
        }
        VerifyDomainIdentityRequest other = (VerifyDomainIdentityRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VerifyDomainIdentityRequest> {
        /**
         * <p>
         * The domain to be verified.
         * </p>
         * 
         * @param domain
         *        The domain to be verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDomainIdentityRequest model) {
            setDomain(model.domain);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public VerifyDomainIdentityRequest build() {
            return new VerifyDomainIdentityRequest(this);
        }
    }
}
