/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns a TXT record that you must publish to the DNS server of your domain to complete domain verification with
 * Amazon SES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VerifyDomainIdentityResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<VerifyDomainIdentityResponse.Builder, VerifyDomainIdentityResponse> {
    private final String verificationToken;

    private VerifyDomainIdentityResponse(BuilderImpl builder) {
        this.verificationToken = builder.verificationToken;
    }

    /**
     * <p>
     * A TXT record that must be placed in the DNS settings for the domain, in order to complete domain verification.
     * </p>
     * 
     * @return A TXT record that must be placed in the DNS settings for the domain, in order to complete domain
     *         verification.
     */
    public String verificationToken() {
        return verificationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((verificationToken() == null) ? 0 : verificationToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDomainIdentityResponse)) {
            return false;
        }
        VerifyDomainIdentityResponse other = (VerifyDomainIdentityResponse) obj;
        if (other.verificationToken() == null ^ this.verificationToken() == null) {
            return false;
        }
        if (other.verificationToken() != null && !other.verificationToken().equals(this.verificationToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (verificationToken() != null) {
            sb.append("VerificationToken: ").append(verificationToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VerifyDomainIdentityResponse> {
        /**
         * <p>
         * A TXT record that must be placed in the DNS settings for the domain, in order to complete domain
         * verification.
         * </p>
         * 
         * @param verificationToken
         *        A TXT record that must be placed in the DNS settings for the domain, in order to complete domain
         *        verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationToken(String verificationToken);
    }

    private static final class BuilderImpl implements Builder {
        private String verificationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDomainIdentityResponse model) {
            setVerificationToken(model.verificationToken);
        }

        public final String getVerificationToken() {
            return verificationToken;
        }

        @Override
        public final Builder verificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        public final void setVerificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
        }

        @Override
        public VerifyDomainIdentityResponse build() {
            return new VerifyDomainIdentityResponse(this);
        }
    }
}
