/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.Map;
import java.util.HashMap;

import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GetIdentityDkimAttributesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetIdentityDkimAttributesResponseUnmarshaller implements
        Unmarshaller<GetIdentityDkimAttributesResponse, StaxUnmarshallerContext> {

    private static class DkimAttributesMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, IdentityDkimAttributes>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, IdentityDkimAttributes> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, IdentityDkimAttributes> entry = new MapEntry<String, IdentityDkimAttributes>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(IdentityDkimAttributesUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final DkimAttributesMapEntryUnmarshaller INSTANCE = new DkimAttributesMapEntryUnmarshaller();

        public static DkimAttributesMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    public GetIdentityDkimAttributesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetIdentityDkimAttributesResponse.Builder getIdentityDkimAttributesResponse = GetIdentityDkimAttributesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.Map<String, IdentityDkimAttributes> dkimAttributes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                getIdentityDkimAttributesResponse.dkimAttributes(dkimAttributes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("DkimAttributes/entry", targetDepth)) {
                    if (dkimAttributes == null) {
                        dkimAttributes = new java.util.HashMap<>();
                    }
                    Entry<String, IdentityDkimAttributes> entry = DkimAttributesMapEntryUnmarshaller.getInstance().unmarshall(
                            context);
                    // getIdentityDkimAttributesResponse.addDkimAttributesEntry(entry.getKey(), entry.getValue());

                    dkimAttributes.put(entry.getKey(), entry.getValue());
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    getIdentityDkimAttributesResponse.dkimAttributes(dkimAttributes);
                    break;
                }
            }
        }
        return getIdentityDkimAttributesResponse.build();
    }

    private static final GetIdentityDkimAttributesResponseUnmarshaller INSTANCE = new GetIdentityDkimAttributesResponseUnmarshaller();

    public static GetIdentityDkimAttributesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
